/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.AlluxioURI;
import alluxio.Server;
import alluxio.clock.Clock;
import alluxio.clock.SystemClock;
import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.AbstractMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.options.CreateDirectoryOptions;
import alluxio.master.file.options.DeleteOptions;
import alluxio.master.file.options.RenameOptions;
import alluxio.master.journal.JournalSystem;
import alluxio.master.keyvalue.KeyValueMaster;
import alluxio.master.keyvalue.KeyValueMasterClientServiceHandler;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.KeyValue;
import alluxio.thrift.KeyValueMasterClientService;
import alluxio.thrift.PartitionInfo;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TProcessor;

@ThreadSafe
public class DefaultKeyValueMaster
extends AbstractMaster
implements KeyValueMaster {
    private static final Set<Class<? extends Server>> DEPS = ImmutableSet.of(FileSystemMaster.class);
    private final FileSystemMaster mFileSystemMaster;
    private final Map<Long, List<PartitionInfo>> mCompleteStoreToPartitions;
    private final Map<Long, List<PartitionInfo>> mIncompleteStoreToPartitions;

    DefaultKeyValueMaster(FileSystemMaster fileSystemMaster, JournalSystem journalSystem) {
        super(journalSystem, (Clock)new SystemClock(), ExecutorServiceFactories.fixedThreadPoolExecutorServiceFactory((String)"KeyValueMaster", (int)2));
        this.mFileSystemMaster = fileSystemMaster;
        this.mCompleteStoreToPartitions = new HashMap<Long, List<PartitionInfo>>();
        this.mIncompleteStoreToPartitions = new HashMap<Long, List<PartitionInfo>>();
    }

    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("KeyValueMasterClient", (TProcessor)new KeyValueMasterClientService.Processor((KeyValueMasterClientService.Iface)new KeyValueMasterClientServiceHandler(this)));
        return services;
    }

    public String getName() {
        return "KeyValueMaster";
    }

    public Set<Class<? extends Server>> getDependencies() {
        return DEPS;
    }

    public synchronized void processJournalEntry(Journal.JournalEntry entry) throws IOException {
        block8: {
            try {
                if (entry.hasCreateStore()) {
                    this.createStoreFromEntry(entry.getCreateStore());
                    break block8;
                }
                if (entry.hasCompletePartition()) {
                    this.completePartitionFromEntry(entry.getCompletePartition());
                    break block8;
                }
                if (entry.hasCompleteStore()) {
                    this.completeStoreFromEntry(entry.getCompleteStore());
                    break block8;
                }
                if (entry.hasDeleteStore()) {
                    this.deleteStoreFromEntry(entry.getDeleteStore());
                    break block8;
                }
                if (entry.hasRenameStore()) {
                    this.renameStoreFromEntry(entry.getRenameStore());
                    break block8;
                }
                if (entry.hasMergeStore()) {
                    this.mergeStoreFromEntry(entry.getMergeStore());
                    break block8;
                }
                throw new IOException(ExceptionMessage.UNEXPECTED_JOURNAL_ENTRY.getMessage(new Object[]{entry}));
            }
            catch (AlluxioException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void resetState() {
        this.mCompleteStoreToPartitions.clear();
        this.mIncompleteStoreToPartitions.clear();
    }

    public synchronized Iterator<Journal.JournalEntry> getJournalEntryIterator() {
        return Iterators.concat(this.getStoreIterator(this.mCompleteStoreToPartitions), this.getStoreIterator(this.mIncompleteStoreToPartitions));
    }

    public void start(Boolean isLeader) throws IOException {
        super.start(isLeader);
    }

    @Override
    public synchronized void completePartition(AlluxioURI path, PartitionInfo info) throws AccessControlException, FileDoesNotExistException, InvalidPathException {
        long fileId = this.mFileSystemMaster.getFileId(path);
        if (fileId == -1L) {
            throw new FileDoesNotExistException(String.format("Failed to completePartition: path %s does not exist", path));
        }
        this.completePartitionInternal(fileId, info);
        this.writeJournalEntry(this.newCompletePartitionEntry(fileId, info));
        this.flushJournal();
    }

    private void completePartitionFromEntry(KeyValue.CompletePartitionEntry entry) throws FileDoesNotExistException {
        PartitionInfo info = new PartitionInfo(entry.getKeyStartBytes().asReadOnlyByteBuffer(), entry.getKeyLimitBytes().asReadOnlyByteBuffer(), entry.getBlockId(), entry.getKeyCount());
        this.completePartitionInternal(entry.getStoreId(), info);
    }

    private void completePartitionInternal(long fileId, PartitionInfo info) throws FileDoesNotExistException {
        if (!this.mIncompleteStoreToPartitions.containsKey(fileId)) {
            throw new FileDoesNotExistException(String.format("Failed to completeStore: KeyValueStore (fileId=%d) was not created before", fileId));
        }
        this.mIncompleteStoreToPartitions.get(fileId).add(new PartitionInfo(info));
    }

    @Override
    public synchronized void completeStore(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException, AccessControlException {
        long fileId = this.mFileSystemMaster.getFileId(path);
        if (fileId == -1L) {
            throw new FileDoesNotExistException(String.format("Failed to completeStore: path %s does not exist", path));
        }
        this.completeStoreInternal(fileId);
        this.writeJournalEntry(this.newCompleteStoreEntry(fileId));
        this.flushJournal();
    }

    private void completeStoreFromEntry(KeyValue.CompleteStoreEntry entry) throws FileDoesNotExistException {
        this.completeStoreInternal(entry.getStoreId());
    }

    private void completeStoreInternal(long fileId) throws FileDoesNotExistException {
        if (!this.mIncompleteStoreToPartitions.containsKey(fileId)) {
            throw new FileDoesNotExistException(String.format("Failed to completeStore: KeyValueStore (fileId=%d) was not created before", fileId));
        }
        List<PartitionInfo> partitions = this.mIncompleteStoreToPartitions.remove(fileId);
        this.mCompleteStoreToPartitions.put(fileId, partitions);
    }

    @Override
    public synchronized void createStore(AlluxioURI path) throws FileAlreadyExistsException, InvalidPathException, AccessControlException {
        try {
            this.mFileSystemMaster.createDirectory(path, (CreateDirectoryOptions)CreateDirectoryOptions.defaults().setRecursive(true));
        }
        catch (IOException e) {
            throw new InvalidPathException(String.format("Failed to createStore: can not create path %s", path), (Throwable)e);
        }
        catch (FileDoesNotExistException e) {
            throw Throwables.propagate((Throwable)e);
        }
        long fileId = this.mFileSystemMaster.getFileId(path);
        Preconditions.checkState((fileId != -1L ? 1 : 0) != 0);
        this.createStoreInternal(fileId);
        this.writeJournalEntry(this.newCreateStoreEntry(fileId));
        this.flushJournal();
    }

    private void createStoreFromEntry(KeyValue.CreateStoreEntry entry) throws FileAlreadyExistsException {
        this.createStoreInternal(entry.getStoreId());
    }

    private void createStoreInternal(long fileId) throws FileAlreadyExistsException {
        if (this.mIncompleteStoreToPartitions.containsKey(fileId)) {
            throw new FileAlreadyExistsException(String.format("Failed to createStore: KeyValueStore (fileId=%d) is already created", fileId));
        }
        this.mIncompleteStoreToPartitions.put(fileId, new ArrayList());
    }

    @Override
    public synchronized void deleteStore(AlluxioURI uri) throws IOException, InvalidPathException, FileDoesNotExistException, AlluxioException {
        long fileId = this.getFileId(uri);
        this.checkIsCompletePartition(fileId, uri);
        this.mFileSystemMaster.delete(uri, DeleteOptions.defaults().setRecursive(true));
        this.deleteStoreInternal(fileId);
        this.writeJournalEntry(this.newDeleteStoreEntry(fileId));
        this.flushJournal();
    }

    private void deleteStoreFromEntry(KeyValue.DeleteStoreEntry entry) {
        this.deleteStoreInternal(entry.getStoreId());
    }

    private void deleteStoreInternal(long fileId) {
        this.mCompleteStoreToPartitions.remove(fileId);
    }

    private long getFileId(AlluxioURI uri) throws AccessControlException, FileDoesNotExistException, InvalidPathException {
        long fileId = this.mFileSystemMaster.getFileId(uri);
        if (fileId == -1L) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{uri}));
        }
        return fileId;
    }

    void checkIsCompletePartition(long fileId, AlluxioURI uri) throws InvalidPathException {
        if (!this.mCompleteStoreToPartitions.containsKey(fileId)) {
            throw new InvalidPathException(ExceptionMessage.INVALID_KEY_VALUE_STORE_URI.getMessage(new Object[]{uri}));
        }
    }

    @Override
    public synchronized void renameStore(AlluxioURI oldUri, AlluxioURI newUri) throws IOException, AlluxioException {
        long oldFileId = this.getFileId(oldUri);
        this.checkIsCompletePartition(oldFileId, oldUri);
        try {
            this.mFileSystemMaster.rename(oldUri, newUri, RenameOptions.defaults());
        }
        catch (FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException(String.format("failed to rename store:the path %s has been used", newUri), (Throwable)e);
        }
        long newFileId = this.mFileSystemMaster.getFileId(newUri);
        Preconditions.checkState((newFileId != -1L ? 1 : 0) != 0);
        this.renameStoreInternal(oldFileId, newFileId);
        this.writeJournalEntry(this.newRenameStoreEntry(oldFileId, newFileId));
        this.flushJournal();
    }

    private void renameStoreInternal(long oldFileId, long newFileId) {
        List<PartitionInfo> partitionsRenamed = this.mCompleteStoreToPartitions.remove(oldFileId);
        this.mCompleteStoreToPartitions.put(newFileId, partitionsRenamed);
    }

    private void renameStoreFromEntry(KeyValue.RenameStoreEntry entry) {
        this.renameStoreInternal(entry.getOldStoreId(), entry.getNewStoreId());
    }

    @Override
    public synchronized void mergeStore(AlluxioURI fromUri, AlluxioURI toUri) throws IOException, FileDoesNotExistException, InvalidPathException, AlluxioException {
        long fromFileId = this.getFileId(fromUri);
        long toFileId = this.getFileId(toUri);
        this.checkIsCompletePartition(fromFileId, fromUri);
        this.checkIsCompletePartition(toFileId, toUri);
        this.mFileSystemMaster.rename(fromUri, new AlluxioURI(PathUtils.concatPath((Object)toUri.toString(), (Object[])new Object[]{String.format("%s-%s", fromUri.getName(), UUID.randomUUID().toString())})), RenameOptions.defaults());
        this.mergeStoreInternal(fromFileId, toFileId);
        this.writeJournalEntry(this.newMergeStoreEntry(fromFileId, toFileId));
        this.flushJournal();
    }

    private void mergeStoreInternal(long fromFileId, long toFileId) {
        List<PartitionInfo> partitionsToBeMerged = this.mCompleteStoreToPartitions.remove(fromFileId);
        this.mCompleteStoreToPartitions.get(toFileId).addAll(partitionsToBeMerged);
    }

    private void mergeStoreFromEntry(KeyValue.MergeStoreEntry entry) {
        this.mergeStoreInternal(entry.getFromStoreId(), entry.getToStoreId());
    }

    @Override
    public synchronized List<PartitionInfo> getPartitionInfo(AlluxioURI path) throws FileDoesNotExistException, AccessControlException, InvalidPathException {
        long fileId = this.getFileId(path);
        List<PartitionInfo> partitions = this.mCompleteStoreToPartitions.get(fileId);
        if (partitions == null) {
            return new ArrayList<PartitionInfo>();
        }
        return partitions;
    }

    private Journal.JournalEntry newCreateStoreEntry(long fileId) {
        KeyValue.CreateStoreEntry createStore = KeyValue.CreateStoreEntry.newBuilder().setStoreId(fileId).build();
        return Journal.JournalEntry.newBuilder().setCreateStore(createStore).build();
    }

    private Journal.JournalEntry newCompletePartitionEntry(long fileId, PartitionInfo info) {
        KeyValue.CompletePartitionEntry completePartition = KeyValue.CompletePartitionEntry.newBuilder().setStoreId(fileId).setBlockId(info.getBlockId()).setKeyStart(new String(info.bufferForKeyStart().array())).setKeyLimit(new String(info.bufferForKeyLimit().array())).setKeyCount(info.getKeyCount()).build();
        return Journal.JournalEntry.newBuilder().setCompletePartition(completePartition).build();
    }

    private Journal.JournalEntry newCompleteStoreEntry(long fileId) {
        KeyValue.CompleteStoreEntry completeStore = KeyValue.CompleteStoreEntry.newBuilder().setStoreId(fileId).build();
        return Journal.JournalEntry.newBuilder().setCompleteStore(completeStore).build();
    }

    private Journal.JournalEntry newDeleteStoreEntry(long fileId) {
        KeyValue.DeleteStoreEntry deleteStore = KeyValue.DeleteStoreEntry.newBuilder().setStoreId(fileId).build();
        return Journal.JournalEntry.newBuilder().setDeleteStore(deleteStore).build();
    }

    private Journal.JournalEntry newRenameStoreEntry(long oldFileId, long newFileId) {
        KeyValue.RenameStoreEntry renameStore = KeyValue.RenameStoreEntry.newBuilder().setOldStoreId(oldFileId).setNewStoreId(newFileId).build();
        return Journal.JournalEntry.newBuilder().setRenameStore(renameStore).build();
    }

    private Journal.JournalEntry newMergeStoreEntry(long fromFileId, long toFileId) {
        KeyValue.MergeStoreEntry mergeStore = KeyValue.MergeStoreEntry.newBuilder().setFromStoreId(fromFileId).setToStoreId(toFileId).build();
        return Journal.JournalEntry.newBuilder().setMergeStore(mergeStore).build();
    }

    private Iterator<Journal.JournalEntry> getStoreIterator(Map<Long, List<PartitionInfo>> storeToPartitions) {
        final Iterator<Map.Entry<Long, List<PartitionInfo>>> it = storeToPartitions.entrySet().iterator();
        return new Iterator<Journal.JournalEntry>(){
            private Map.Entry<Long, List<PartitionInfo>> mEntry;
            private Iterator<PartitionInfo> mInfoIterator;

            @Override
            public boolean hasNext() {
                return this.mEntry != null || this.mInfoIterator != null || it.hasNext();
            }

            @Override
            public Journal.JournalEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.mEntry == null) {
                    Preconditions.checkState((this.mInfoIterator == null ? 1 : 0) != 0);
                    this.mEntry = (Map.Entry)it.next();
                    this.mInfoIterator = this.mEntry.getValue().iterator();
                    return DefaultKeyValueMaster.this.newCreateStoreEntry(this.mEntry.getKey());
                }
                if (this.mInfoIterator.hasNext()) {
                    return DefaultKeyValueMaster.this.newCompletePartitionEntry(this.mEntry.getKey(), this.mInfoIterator.next());
                }
                Journal.JournalEntry completeEntry = DefaultKeyValueMaster.this.newCompleteStoreEntry(this.mEntry.getKey());
                this.mEntry = null;
                this.mInfoIterator = null;
                return completeEntry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported.");
            }
        };
    }
}

