/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.dome;

import com.rits.cloning.Cloner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.agmip.dome.Assume;
import org.agmip.dome.Calculate;
import org.agmip.dome.Command;
import org.agmip.dome.DomeUtil;
import org.agmip.dome.Generate;
import org.agmip.functions.ExperimentHelper;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    private static final Logger log = LoggerFactory.getLogger(Engine.class);
    private ArrayList<HashMap<String, String>> rules;
    private ArrayList<HashMap<String, String>> generators;
    private boolean allowGenerators;
    private boolean isSWExtracted = false;
    private ArrayList<ArrayList<HashMap<String, String>>> genGroups;
    private ArrayList<HashMap<String, String>> genRules = null;
    HashSet<String> keysToExtractFinal = new HashSet();
    private int cur = 0;

    public Engine(HashMap<String, Object> dome, boolean allowGenerators) {
        this.rules = DomeUtil.getRules(dome);
        this.generators = new ArrayList();
        this.genGroups = allowGenerators ? DomeUtil.getGenerators(dome) : new ArrayList();
        this.allowGenerators = allowGenerators;
    }

    public Engine(HashMap<String, Object> dome) {
        this(dome, false);
    }

    public Engine(ArrayList<HashMap<String, String>> rules) {
        this.rules = rules;
        this.generators = new ArrayList();
        this.genGroups = new ArrayList();
        this.allowGenerators = false;
    }

    protected Engine() {
        this.rules = new ArrayList();
        this.generators = new ArrayList();
        this.genGroups = new ArrayList();
        this.allowGenerators = false;
    }

    public void appendRules(ArrayList<HashMap<String, String>> rules) {
        this.rules.addAll(rules);
    }

    public void apply(HashMap<String, Object> data) {
        for (HashMap<String, String> rule : this.rules) {
            if (this.isSWExtracted && this.isSoilWthRules(rule)) continue;
            this.applyRule(data, rule);
        }
    }

    private void applyRule(HashMap<String, Object> data, HashMap<String, String> rule) {
        String cmd = rule.get("cmd").toUpperCase();
        if (rule.get("variable") == null) {
            log.error("Invalid rule: {}", (Object)rule.toString());
            return;
        }
        String a = rule.get("args");
        if (a == null) {
            a = "";
        }
        String[] args = a.split("[|]");
        if (cmd.equals("INFO")) {
            log.debug("Recevied an INFO command");
        } else if (cmd.equals("FILL") || cmd.equals("REPLACE") || cmd.equals("REPLACE_FIELD_ONLY")) {
            boolean replace = true;
            if (cmd.equals("FILL")) {
                replace = false;
            }
            if (args[0].endsWith("()")) {
                if (cmd.equals("REPLACE_FIELD_ONLY")) {
                    log.debug("Found FIELD_ONLY replace");
                    if (data.containsKey("seasonal_dome_applied")) {
                        log.info("Replace for {} not applied due to FIELD_ONLY restriction", (Object)rule.get("variable"));
                    } else {
                        log.debug("Found data without seasonal_dome_applied set.");
                        Calculate.run(data, rule.get("variable"), args, replace);
                    }
                } else {
                    Calculate.run(data, rule.get("variable"), args, replace);
                }
            } else if (cmd.equals("REPLACE_FIELD_ONLY")) {
                log.debug("Found FIELD_ONLY replace");
                if (data.containsKey("seasonal_dome_applied")) {
                    log.info("Replace for {} not applied due to FIELD_ONLY restriction", (Object)rule.get("variable"));
                } else {
                    log.debug("Found data without seasonal_dome_applied set.");
                    Assume.run(data, rule.get("variable"), args, replace);
                }
            } else {
                Assume.run(data, rule.get("variable"), args, replace);
            }
        } else if (cmd.equals("CREATE")) {
            Calculate.create(data, rule.get("variable"), args);
        } else {
            log.error("Invalid command: [{}]", (Object)cmd);
        }
    }

    public ArrayList<HashMap<String, Object>> applyStg(HashMap<String, Object> data) {
        if (this.hasMoreGenRules()) {
            ArrayList<HashMap<String, Object>> arr = new ArrayList<HashMap<String, Object>>();
            if (this.genRules != null && !this.genRules.isEmpty()) {
                for (int i = 0; i < this.genRules.size() - 1; ++i) {
                    HashMap<String, String> rule = this.genRules.get(i);
                    this.applyRule(data, rule);
                }
                HashMap<String, String> gemRule = this.genRules.get(this.genRules.size() - 1);
                if (!gemRule.isEmpty()) {
                    this.generators.add(gemRule);
                    arr = this.runGenerators(data, this.cur != this.genGroups.size());
                    this.generators.clear();
                }
            }
            if (arr.isEmpty()) {
                return this.applyStg(data);
            }
            return this.applyStg(arr);
        }
        ArrayList<HashMap<String, Object>> results = new ArrayList<HashMap<String, Object>>();
        results.add(data);
        return results;
    }

    public ArrayList<HashMap<String, Object>> applyStg(ArrayList<HashMap<String, Object>> dataArr) {
        ArrayList<HashMap<String, Object>> results = new ArrayList();
        if (this.hasMoreGenRules()) {
            if (this.genRules != null && !this.genRules.isEmpty()) {
                for (HashMap<String, Object> data : dataArr) {
                    ArrayList arr = new ArrayList();
                    for (int i = 0; i < this.genRules.size() - 1; ++i) {
                        HashMap<String, String> rule = this.genRules.get(i);
                        this.applyRule(data, rule);
                    }
                }
                HashMap<String, String> gemRule = this.genRules.get(this.genRules.size() - 1);
                if (!gemRule.isEmpty()) {
                    this.generators.add(gemRule);
                    results = this.runGenerators(dataArr, this.cur != this.genGroups.size());
                    this.generators.clear();
                } else {
                    results = dataArr;
                }
            }
            results = this.applyStg(results);
        } else {
            results = dataArr;
            boolean wthRefFlg = !this.keysToExtractFinal.contains("weather");
            boolean soilRefFlg = !this.keysToExtractFinal.contains("soil");
            for (HashMap<String, Object> result : results) {
                if (wthRefFlg) {
                    result.remove("weather");
                }
                if (!soilRefFlg) continue;
                result.remove("soil");
            }
        }
        return results;
    }

    public ArrayList<HashMap<String, Object>> runGenerators(HashMap<String, Object> data) {
        return this.runGenerators(data, false);
    }

    public ArrayList<HashMap<String, Object>> runGenerators(HashMap<String, Object> data, boolean refLeftFlg) {
        if (this.allowGenerators) {
            log.debug("Starting generators");
            ArrayList<HashMap<String, Object>> results = new ArrayList<HashMap<String, Object>>();
            HashSet<String> keysToExtract = new HashSet<String>();
            ArrayList<HashMap<String, String>> gAcc = new ArrayList<HashMap<String, String>>();
            ArrayList<ArrayList<HashMap<String, String>>> newEventArrs = new ArrayList<ArrayList<HashMap<String, String>>>();
            for (HashMap<String, String> generator : this.generators) {
                String[] stringArray;
                if (generator.get("variable") == null) {
                    log.error("Invalid generator: {}", (Object)generator.toString());
                    return new ArrayList<HashMap<String, Object>>();
                }
                String path = Command.getPathOrRoot(generator.get("variable"));
                if (path.contains("weather")) {
                    keysToExtract.add("weather");
                } else if (path.contains("soil")) {
                    keysToExtract.add("soil");
                } else {
                    keysToExtract.add("experiment");
                }
                String a = generator.get("args");
                if (a == null) {
                    a = "";
                }
                if ((stringArray = a.split("[|]"))[0].toUpperCase().equals("AUTO_REPLICATE_EVENTS()")) {
                    newEventArrs = Generate.runEvent(data, stringArray, newEventArrs);
                    continue;
                }
                gAcc = Generate.run(data, stringArray, gAcc);
            }
            HashMap<String, Object> tempRefHolder = new HashMap<String, Object>();
            if (!keysToExtract.contains("weather")) {
                tempRefHolder.put("weather", data.remove("weather"));
            }
            if (!keysToExtract.contains("soil")) {
                tempRefHolder.put("soil", data.remove("soil"));
            }
            if (refLeftFlg) {
                this.keysToExtractFinal.addAll(keysToExtract);
            }
            Cloner cloner = new Cloner();
            if (newEventArrs.isEmpty()) {
                int i = 0;
                for (HashMap hashMap : gAcc) {
                    Generate.applyGeneratedRules(data, hashMap, "" + ++i);
                    HashMap newData = (HashMap)cloner.deepClone(data);
                    if (refLeftFlg) {
                        newData.putAll(tempRefHolder);
                    }
                    results.add(newData);
                }
            } else {
                int i = 0;
                for (ArrayList arrayList : newEventArrs) {
                    Generate.applyReplicatedEvents(data, arrayList, "" + ++i);
                    HashMap newData = (HashMap)cloner.deepClone(data);
                    if (refLeftFlg) {
                        newData.putAll(tempRefHolder);
                    }
                    results.add(newData);
                }
            }
            return results;
        }
        log.error("You cannot run generators in this mode.");
        return new ArrayList<HashMap<String, Object>>();
    }

    public ArrayList<HashMap<String, Object>> runGenerators(ArrayList<HashMap<String, Object>> dataArr, boolean refLeftFlg) {
        if (this.allowGenerators) {
            log.debug("Starting generators");
            ArrayList<HashMap<String, Object>> results = new ArrayList<HashMap<String, Object>>();
            HashSet<String> keysToExtract = new HashSet<String>();
            ArrayList<HashMap<String, String>> gAcc = new ArrayList<HashMap<String, String>>();
            ArrayList newEventArrs = new ArrayList();
            for (HashMap<String, String> generator : this.generators) {
                String[] args;
                if (generator.get("variable") == null) {
                    log.error("Invalid generator: {}", (Object)generator.toString());
                    return new ArrayList<HashMap<String, Object>>();
                }
                String path = Command.getPathOrRoot(generator.get("variable"));
                if (path.contains("weather")) {
                    keysToExtract.add("weather");
                } else if (path.contains("soil")) {
                    keysToExtract.add("soil");
                } else {
                    keysToExtract.add("experiment");
                }
                String a = generator.get("args");
                if (a == null) {
                    a = "";
                }
                if ((args = a.split("[|]"))[0].toUpperCase().equals("AUTO_REPLICATE_EVENTS()")) {
                    String[] pdates = new String[dataArr.size()];
                    block1: for (int i = 0; i < dataArr.size(); ++i) {
                        pdates[i] = "";
                        HashMap<String, Object> data = dataArr.get(i);
                        ArrayList events = MapUtil.getBucket(data, (String)"management").getDataList();
                        for (HashMap event : events) {
                            if (!"planting".equals(MapUtil.getValueOr((Map)event, (String)"event", (String)""))) continue;
                            pdates[i] = MapUtil.getValueOr((Map)event, (String)"date", (String)"");
                            continue block1;
                        }
                    }
                    HashMap<Object, Object> data = dataArr.isEmpty() ? new HashMap() : dataArr.get(0);
                    newEventArrs = ExperimentHelper.getAutoEventDate(data, (String[])pdates);
                    continue;
                }
                HashMap<Object, Object> data = dataArr.isEmpty() ? new HashMap() : dataArr.get(0);
                gAcc = Generate.run(data, args, gAcc);
            }
            if (refLeftFlg) {
                this.keysToExtractFinal.addAll(keysToExtract);
            }
            if (newEventArrs.isEmpty()) {
                if (gAcc.size() != dataArr.size()) {
                    log.error("The number of calculated values is not match with the number of generated experiments");
                    return results;
                }
                for (int i = 0; i < gAcc.size(); ++i) {
                    Generate.applyGeneratedRules(dataArr.get(i), (HashMap)gAcc.get(i), null);
                }
                results = dataArr;
            } else {
                if (newEventArrs.size() != dataArr.size()) {
                    log.error("The number of calculated events is not match with the number of generated experiments");
                    return results;
                }
                for (int i = 0; i < newEventArrs.size(); ++i) {
                    Generate.applyReplicatedEvents(dataArr.get(i), (ArrayList)newEventArrs.get(i), null);
                }
                results = dataArr;
            }
            return results;
        }
        log.error("You cannot run generators in this mode.");
        return new ArrayList<HashMap<String, Object>>();
    }

    public boolean updateWSRef(HashMap<String, Object> exp, boolean isStgDome, boolean isStgMode) {
        boolean isClimIDchanged = false;
        for (HashMap<String, String> rule : this.rules) {
            String var = MapUtil.getValueOr(rule, (String)"variable", (String)"").toLowerCase();
            String cmd = MapUtil.getValueOr(rule, (String)"cmd", (String)"").toUpperCase();
            if (var.equals("clim_id")) {
                String wst_id = MapUtil.getValueOr(exp, (String)"wst_id", (String)"");
                String val = MapUtil.getValueOr(rule, (String)"args", (String)"").toUpperCase();
                if (val.equals("")) {
                    val = "0XXX";
                }
                if (isStgDome || !isStgMode && val.startsWith("0")) {
                    if (wst_id.length() > 4) {
                        wst_id = wst_id.substring(0, 4) + val;
                    } else if (wst_id.length() > 0) {
                        wst_id = wst_id + val;
                    }
                    HashMap<String, String> newRule = new HashMap<String, String>();
                    newRule.put("cmd", "REPLACE");
                    newRule.put("args", wst_id);
                    newRule.put("variable", "wst_id");
                    this.applyRule(exp, newRule);
                    exp.remove("soil");
                    exp.remove("weather");
                    exp.put("clim_id", val);
                    isClimIDchanged = true;
                }
                if (!isStgMode && !val.startsWith("0")) {
                    log.warn("Invalid CLIM_ID assigned for baseline weather data: {}", (Object)val);
                }
                if (cmd.equals("INFO")) continue;
                rule.put("cmd", "INFO");
                continue;
            }
            if (!var.equals("wst_id") && !var.equals("soil_id")) continue;
            if (!cmd.equals("FILL")) {
                rule.put("cmd", "REPLACE");
            }
            this.applyRule(exp, rule);
            exp.remove("soil");
            exp.remove("weather");
            if (cmd.equals("FILL")) continue;
            rule.put("cmd", "INFO");
        }
        return isClimIDchanged;
    }

    protected void addRule(HashMap<String, String> rule) {
        this.rules.add(rule);
    }

    protected void addGenerator(HashMap<String, String> generator) {
        this.generators.add(generator);
    }

    protected void addGenGroup(ArrayList<HashMap<String, String>> rules, HashMap<String, String> generator) {
        ArrayList<HashMap<String, String>> genGroup = new ArrayList<HashMap<String, String>>();
        genGroup.addAll(rules);
        genGroup.add(generator);
        this.genGroups.add(genGroup);
    }

    protected void enableGenerators() {
        this.allowGenerators = true;
    }

    protected void disableGenerators() {
        this.allowGenerators = false;
    }

    private boolean hasMoreGenRules() {
        if (this.cur < this.genGroups.size()) {
            this.genRules = this.genGroups.get(this.cur);
            ++this.cur;
            return true;
        }
        this.genRules = null;
        return false;
    }

    public ArrayList<String> getGenerators() {
        ArrayList<String> genList = new ArrayList<String>();
        for (ArrayList<HashMap<String, String>> genGroup : this.genGroups) {
            HashMap<String, String> genRule;
            if (genGroup.isEmpty() || (genRule = genGroup.get(genGroup.size() - 1)).isEmpty()) continue;
            genList.add(genRule.get("cmd") + "," + genRule.get("variable") + "," + genRule.get("args"));
        }
        return genList;
    }

    public ArrayList<HashMap<String, String>> extractSoilWthRules() {
        ArrayList<HashMap<String, String>> swRules;
        if (this.allowGenerators) {
            swRules = new ArrayList();
            for (ArrayList<HashMap<String, String>> genGroup : this.genGroups) {
                swRules.addAll(this.extractSoilWthRules(genGroup));
            }
        } else {
            swRules = this.extractSoilWthRules(this.rules);
        }
        this.isSWExtracted = true;
        return swRules;
    }

    private ArrayList<HashMap<String, String>> extractSoilWthRules(ArrayList<HashMap<String, String>> rules) {
        ArrayList<HashMap<String, String>> swRules = new ArrayList<HashMap<String, String>>();
        for (HashMap<String, String> rule : rules) {
            if (!this.isSoilWthRules(rule)) continue;
            swRules.add(rule);
        }
        return swRules;
    }

    private boolean isSoilWthRules(HashMap<String, String> rule) {
        boolean isSWRule = false;
        String cmd = rule.get("cmd").toUpperCase();
        String var = rule.get("variable");
        if (var == null) {
            log.error("Invalid rule: {}", (Object)rule.toString());
            return isSWRule;
        }
        String a = rule.get("args");
        if (a == null) {
            a = "";
        }
        String[] args = a.split("[|]");
        if (cmd.equals("INFO")) {
            log.debug("Recevied an INFO command");
        } else if (cmd.equals("FILL") || cmd.equals("REPLACE") || cmd.equals("REPLACE_FIELD_ONLY")) {
            if (!args[0].endsWith("()") || args[0].equals("OFFSET()") || args[0].equals("MULTIPLY()") || args[0].equals("OFFSET_DATE()") || args[0].equals("DATE_OFFSET()") || args[0].equals("ROOT_DIST()") || args[0].equals("LYRSET()") || args[0].equals("TRANSPOSE()")) {
                String[] paths;
                String path = Command.getPathOrRoot(var);
                for (String p : paths = path.split(",")) {
                    if (!p.equals("soil") && !p.equals("soil@soilLayer") && !p.equals("weather") && !p.equals("weather@dailyWeather")) continue;
                    isSWRule = true;
                    break;
                }
            } else if (args[0].equals("STABLEC()") || args[0].equals("PTCALC()") || args[0].equals("TAVAMP()")) {
                isSWRule = true;
            }
        }
        return isSWRule;
    }
}

