/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.dome;

import java.util.ArrayList;
import java.util.HashMap;
import org.agmip.ace.AcePathfinder;
import org.agmip.ace.util.AcePathfinderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command {
    protected static final Logger log = LoggerFactory.getLogger(Command.class);

    public static String getRawValue(HashMap m, String var) {
        if (var == null) {
            return "";
        }
        String path = Command.getPathOrRoot(var);
        if (path.equals("")) {
            if (m.containsKey(var)) {
                return (String)m.get(var);
            }
            return "";
        }
        if (path.contains("@")) {
            ArrayList<HashMap<String, Object>> base;
            boolean isEvent = false;
            if (path.contains("!")) {
                isEvent = true;
            }
            if ((base = Command.traverseAndGetSiblings(m, var)) == null || base.isEmpty()) {
                return "";
            }
            var = AcePathfinderUtil.setEventDateVar((String)var, (boolean)isEvent);
            log.debug("Looking for var: {}", (Object)var);
            for (HashMap<String, Object> item : base) {
                if (!item.containsKey(var)) continue;
                return (String)item.get(var);
            }
            return "";
        }
        HashMap pointer = AcePathfinderUtil.traverseToPoint((HashMap)m, (String)path);
        if (pointer == null) {
            pointer = m;
        }
        if (pointer.containsKey(var)) {
            return (String)pointer.get(var);
        }
        return "";
    }

    public static ArrayList<HashMap<String, Object>> traverseAndGetSiblings(HashMap m, String var) {
        String[] temp;
        ArrayList<HashMap<String, Object>> def = new ArrayList<HashMap<String, Object>>();
        if (var == null) {
            return def;
        }
        String path = AcePathfinder.INSTANCE.getPath(var);
        if (path == null) {
            return def;
        }
        if (!path.contains("@")) {
            return def;
        }
        HashMap pointer = AcePathfinderUtil.traverseToPoint((HashMap)m, (String)path);
        if (pointer == null) {
            pointer = m;
        }
        if (!pointer.containsKey((temp = path.split("[@!]"))[1])) {
            return def;
        }
        return (ArrayList)pointer.get(temp[1]);
    }

    protected static boolean varHasValue(HashMap m, String var, boolean isEvent) {
        var = AcePathfinderUtil.setEventDateVar((String)var, (boolean)isEvent);
        log.debug("Looking for var {} in {}", (Object)var, (Object)m.toString());
        return m.containsKey(var);
    }

    public static void run(HashMap m, String var, String[] args, boolean replace) {
        log.error("This should be overridden in the subclass");
    }

    public static String getPathOrRoot(String var) {
        return Command.getPathOr(var, "");
    }

    public static String getPathOr(String var, String def) {
        String path = AcePathfinder.INSTANCE.getPath(var);
        if (path == null) {
            path = def;
        }
        return path;
    }
}

