/*
 * Decompiled with CFR 0.152.
 */
package nu.pattern;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.opencv.core.Core;

public class OpenCV {
    private static final Logger logger = Logger.getLogger(OpenCV.class.getName());

    public static void loadLibrary() {
        try {
            System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError ule) {
            String location;
            OS os = OS.getCurrent();
            Arch arch = Arch.getCurrent();
            block2 : switch (os) {
                case LINUX: {
                    switch (arch) {
                        case X86_32: {
                            location = "/nu/pattern/opencv/linux/x86_32/libopencv_java249.so";
                            break block2;
                        }
                        case X86_64: {
                            location = "/nu/pattern/opencv/linux/x86_64/libopencv_java249.so";
                            break block2;
                        }
                    }
                    throw new UnsupportedPlatformException(os, arch);
                }
                case OSX: {
                    switch (arch) {
                        case X86_64: {
                            location = "/nu/pattern/opencv/osx/x86_64/libopencv_java249.dylib";
                            break block2;
                        }
                    }
                    throw new UnsupportedPlatformException(os, arch);
                }
                default: {
                    throw new UnsupportedPlatformException(os, arch);
                }
            }
            logger.log(Level.FINEST, "Selected native binary \"{0}\".", location);
            InputStream binary = OpenCV.class.getResourceAsStream(location);
            Path destination = new TemporaryDirectory().markDeleteOnExit().getPath().resolve("./" + location).normalize();
            try {
                logger.log(Level.FINEST, "Copying native binary to \"{0}\".", destination);
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                Files.copy(binary, destination, new CopyOption[0]);
                logger.log(Level.FINEST, "Loading native binary at \"{0}\".", destination);
                String originalLibaryPath = System.getProperty("java.library.path");
                System.setProperty("java.library.path", originalLibaryPath + System.getProperty("path.separator") + destination.getParent());
                Field systemPathsField = ClassLoader.class.getDeclaredField("sys_paths");
                systemPathsField.setAccessible(true);
                systemPathsField.set(null, null);
                logger.log(Level.FINEST, "System library path now \"{0}\".", System.getProperty("java.library.path"));
                logger.log(Level.FINEST, "Native library \"{0}\" maps to \"{1}\".", new Object[]{Core.NATIVE_LIBRARY_NAME, System.mapLibraryName(Core.NATIVE_LIBRARY_NAME)});
                System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
            }
            catch (IOException ioe) {
                throw new IllegalStateException(String.format("Error writing native library to \"%s\".", destination), ioe);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            logger.log(Level.FINEST, "Completed native OpenCV library loading.");
        }
    }

    private static class TemporaryDirectory {
        final Path path;

        public TemporaryDirectory() {
            try {
                this.path = Files.createTempDirectory("", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public TemporaryDirectory markDeleteOnExit() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    TemporaryDirectory.this.delete();
                }
            });
            return this;
        }

        public void delete() {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return;
            }
            try {
                Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        Files.deleteIfExists(dir);
                        return super.postVisitDirectory(dir, e);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class UnsupportedPlatformException
    extends RuntimeException {
        private UnsupportedPlatformException(OS os, Arch arch) {
            super(String.format("Operating system \"%s\" and architecture \"%s\" are not supported.", new Object[]{os, arch}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Arch {
        X86_32("i386", "i686"),
        X86_64("amd64", "x86_64");

        private final Set<String> patterns;

        private Arch(String ... patterns) {
            this.patterns = new HashSet<String>(Arrays.asList(patterns));
        }

        private boolean is(String id) {
            return this.patterns.contains(id);
        }

        public static Arch getCurrent() {
            String osArch = System.getProperty("os.arch");
            for (Arch arch : Arch.values()) {
                if (!arch.is(osArch)) continue;
                logger.log(Level.FINEST, "Current environment matches architecture descriptor \"{0}\".", (Object)arch);
                return arch;
            }
            throw new UnsupportedOperationException(String.format("Architecture \"%s\" is not supported.", osArch));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OS {
        OSX("^[Mm]ac OS X$"),
        LINUX("^[Ll]inux$"),
        WINDOWS("^[Ww]indows.*");

        private final Set<Pattern> patterns = new HashSet<Pattern>();

        private OS(String ... patterns) {
            for (String pattern : patterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
        }

        private boolean is(String id) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(id).matches()) continue;
                return true;
            }
            return false;
        }

        public static OS getCurrent() {
            String osName = System.getProperty("os.name");
            for (OS os : OS.values()) {
                if (!os.is(osName)) continue;
                logger.log(Level.FINEST, "Current environment matches operating system descriptor \"{0}\".", (Object)os);
                return os;
            }
            throw new UnsupportedOperationException(String.format("Operating system \"%s\" is not supported.", osName));
        }
    }
}

