/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class AbstractNodeWrapper
implements NodeInfo,
VirtualNode {
    protected TreeInfo treeInfo;

    public TreeInfo getTreeInfo() {
        return this.treeInfo;
    }

    public final NodeInfo head() {
        return this;
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public final Object getRealNode() {
        return this.getUnderlyingNode();
    }

    public Configuration getConfiguration() {
        return this.getTreeInfo().getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public AtomicSequence atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public SchemaType getSchemaType() {
        if (this.getNodeKind() == 2) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return Untyped.getInstance();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof AbstractNodeWrapper)) {
            return false;
        }
        AbstractNodeWrapper ow = (AbstractNodeWrapper)other;
        return this.getUnderlyingNode().equals(ow.getUnderlyingNode());
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }

    public String getSystemId() {
        if (this.treeInfo instanceof GenericTreeInfo) {
            return ((GenericTreeInfo)this.treeInfo).getSystemId();
        }
        throw new UnsupportedOperationException();
    }

    public void setSystemId(String uri) {
        if (!(this.treeInfo instanceof GenericTreeInfo)) {
            throw new UnsupportedOperationException();
        }
        ((GenericTreeInfo)this.treeInfo).setSystemId(uri);
    }

    public String getPublicId() {
        return null;
    }

    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeInfo n = this;
        if (this.getNodeKind() != 1) {
            n = this.getParent();
        }
        while (n != null) {
            String xmlbase = n.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            if (xmlbase != null) {
                return xmlbase;
            }
            n = n.getParent();
        }
        return this.getRoot().getSystemId();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public Location saveLocation() {
        return this;
    }

    public int comparePosition(NodeInfo other) {
        return Navigator.comparePosition(this, other);
    }

    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    private int getNameCode() {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public String getDisplayName() {
        String prefix = this.getPrefix();
        String local = this.getLocalPart();
        if (prefix.isEmpty()) {
            return local;
        }
        return prefix + ":" + local;
    }

    public String getAttributeValue(String uri, String local) {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        int nodeKind = this.getNodeKind();
        switch (axisNumber) {
            case 0: {
                if (nodeKind == 9) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 2: {
                if (nodeKind != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return this.iterateAttributes(nodeTest);
            }
            case 3: {
                if (nodeKind == 1 || nodeKind == 9) {
                    return this.iterateChildren(nodeTest);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 4: {
                if (nodeKind == 1 || nodeKind == 9) {
                    return this.iterateDescendants(nodeTest, false);
                }
                return EmptyIterator.OfNodes.THE_INSTANCE;
            }
            case 5: {
                if (nodeKind == 1 || nodeKind == 9) {
                    return this.iterateDescendants(nodeTest, true);
                }
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
            }
            case 7: {
                switch (nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.OfNodes.THE_INSTANCE;
                    }
                }
                return this.iterateSiblings(nodeTest, true);
            }
            case 8: {
                if (nodeKind != 1) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return NamespaceNode.makeIterator(this, nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
            }
            case 11: {
                switch (nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.OfNodes.THE_INSTANCE;
                    }
                }
                return this.iterateSiblings(nodeTest, false);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    protected abstract AxisIterator iterateAttributes(NodeTest var1);

    protected abstract AxisIterator iterateChildren(NodeTest var1);

    protected abstract AxisIterator iterateSiblings(NodeTest var1, boolean var2);

    protected abstract AxisIterator iterateDescendants(NodeTest var1, boolean var2);

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return new NamespaceBinding[0];
    }

    public NodeInfo getRoot() {
        NodeInfo p = this;
        NodeInfo q;
        while ((q = p.getParent()) != null) {
            p = q;
        }
        return p;
    }

    public boolean hasChildNodes() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                return this.iterateAxis((byte)3).next() != null;
            }
        }
        return false;
    }

    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        Navigator.copy(this, out, copyOptions, locationId);
    }

    public boolean isId() {
        return false;
    }

    public boolean isIdref() {
        return false;
    }

    public boolean isNilled() {
        return false;
    }
}

