/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;

final class AttributeEnumeration
extends AxisIteratorImpl
implements LookaheadIterator {
    private ElementImpl element;
    private AttributeCollectionImpl attributes;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;

    public AttributeEnumeration(NodeImpl node, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (node.getNodeKind() == 1) {
            this.element = (ElementImpl)node;
            this.attributes = (AttributeCollectionImpl)this.element.getAttributeList();
            AttributeCollection attlist = this.element.getAttributeList();
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest test = (NameTest)nodeTest;
                this.index = attlist.getIndexByFingerprint(test.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = new AttributeImpl(this.element, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attlist.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public NodeInfo next() {
        if (this.next == null) {
            return null;
        }
        NodeInfo current = this.next;
        this.advance();
        return current;
    }

    private void advance() {
        while (true) {
            if (this.index >= this.length) {
                this.next = null;
                return;
            }
            if (this.attributes.isDeleted(this.index)) {
                ++this.index;
                continue;
            }
            this.next = new AttributeImpl(this.element, this.index);
            ++this.index;
            if (this.nodeTest.matchesNode(this.next)) break;
        }
    }

    public AxisIterator getAnother() {
        return new AttributeEnumeration(this.element, this.nodeTest);
    }

    public int getProperties() {
        return 4;
    }
}

