/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.IOException;
import java.io.InputStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.trans.XPathException;

public class JSONResource
implements Resource {
    private String href;
    private String jsonStr;
    private InputStream inputStream;
    private String contentType = "application/json";
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        public Resource makeResource(Configuration config, String resourceURI, String contentType, AbstractResourceCollection.InputDetails details) throws XPathException {
            return new JSONResource(resourceURI, details.inputStream);
        }
    };

    public JSONResource(String href, InputStream in) {
        this.href = href;
        this.inputStream = in;
    }

    public String getResourceURI() {
        return this.href;
    }

    public Item getItem(XPathContext context) throws XPathException {
        if (this.jsonStr == null) {
            try {
                StringBuilder sb = CatalogCollection.makeStringBuilderFromStream(this.inputStream);
                this.jsonStr = sb.toString();
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
        HashTrieMap options = new HashTrieMap(context);
        Item item = ParseJsonFn.parse(this.jsonStr, options, context);
        return item;
    }

    public String getContentType() {
        return this.contentType;
    }
}

