/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.OrderByClausePull;
import net.sf.saxon.expr.flwor.OrderByClausePush;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class OrderByClause
extends Clause {
    Operand sortKeysOp;
    AtomicComparer[] comparators;
    Operand tupleOp;

    public OrderByClause(FLWORExpression flwor, SortKeyDefinition[] sortKeys, TupleExpression tupleExpression) {
        this.sortKeysOp = new Operand(flwor, new SortKeyDefinitionList(sortKeys), OperandRole.REPEAT_NAVIGATE);
        this.tupleOp = new Operand(flwor, tupleExpression, OperandRole.REPEAT_NAVIGATE);
    }

    public int getClauseKey() {
        return 5;
    }

    public boolean containsNonInlineableVariableReference(Binding binding) {
        return this.getTupleExpression().includesBinding(binding);
    }

    public OrderByClause copy(FLWORExpression flwor, RebindingMap rebindings) {
        SortKeyDefinitionList sortKeys = this.getSortKeyDefinitions();
        SortKeyDefinition[] sk2 = new SortKeyDefinition[sortKeys.size()];
        for (int i = 0; i < sortKeys.size(); ++i) {
            sk2[i] = sortKeys.getSortKeyDefinition(i).copy(rebindings);
        }
        OrderByClause obc = new OrderByClause(flwor, sk2, (TupleExpression)this.getTupleExpression().copy(rebindings));
        obc.setLocation(this.getLocation());
        obc.setPackageData(this.getPackageData());
        obc.comparators = this.comparators;
        return obc;
    }

    public SortKeyDefinitionList getSortKeyDefinitions() {
        return (SortKeyDefinitionList)this.sortKeysOp.getChildExpression();
    }

    public AtomicComparer[] getAtomicComparers() {
        return this.comparators;
    }

    public TupleExpression getTupleExpression() {
        return (TupleExpression)this.tupleOp.getChildExpression();
    }

    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new OrderByClausePull(base, this.getTupleExpression(), this, context);
    }

    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        return new OrderByClausePush(destination, this.getTupleExpression(), this, context);
    }

    public void processOperands(OperandProcessor processor) throws XPathException {
        processor.processOperand(this.tupleOp);
        processor.processOperand(this.sortKeysOp);
    }

    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean allKeysFixed = true;
        SortKeyDefinitionList sortKeys = this.getSortKeyDefinitions();
        for (SortKeyDefinition sk : sortKeys) {
            if (sk.isFixed()) continue;
            allKeysFixed = false;
            break;
        }
        if (allKeysFixed) {
            this.comparators = new AtomicComparer[sortKeys.size()];
        }
        int i = 0;
        for (SortKeyDefinition skd : sortKeys) {
            Expression sortKey = skd.getSortKey();
            RoleDiagnostic role = new RoleDiagnostic(6, "", i);
            role.setErrorCode("XPTY0004");
            sortKey = TypeChecker.staticTypeCheck(sortKey, SequenceType.OPTIONAL_ATOMIC, false, role, visitor);
            skd.setSortKey(sortKey, false);
            skd.typeCheck(visitor, contextInfo);
            if (skd.isFixed()) {
                AtomicComparer comp = skd.makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
                skd.setFinalComparator(comp);
                if (allKeysFixed) {
                    this.comparators[i] = comp;
                }
            }
            ++i;
        }
    }

    public void explain(ExpressionPresenter out) throws XPathException {
        out.startElement("order-by");
        for (SortKeyDefinition k : this.getSortKeyDefinitions()) {
            out.startSubsidiaryElement("key");
            k.getSortKey().export(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("order by ... ");
        return fsb.toString();
    }

    public AtomicValue evaluateSortKey(int n, XPathContext c) throws XPathException {
        SortKeyDefinitionList sortKeys = this.getSortKeyDefinitions();
        return (AtomicValue)sortKeys.getSortKeyDefinition(n).getSortKey().evaluateItem(c);
    }
}

