/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class SequenceComposer
implements SequenceIterator {
    private EventIterator base;
    private PipelineConfiguration pipe;

    public SequenceComposer(EventIterator iter, PipelineConfiguration pipe) {
        this.base = EventStackIterator.flatten(iter);
        this.pipe = pipe;
    }

    public Item next() throws XPathException {
        PullEvent pe = this.base.next();
        if (pe == null) {
            return null;
        }
        if (pe instanceof Item) {
            return (Item)pe;
        }
        if (pe instanceof StartDocumentEvent || pe instanceof StartElementEvent) {
            SubtreeIterator sub = new SubtreeIterator(this.base, pe);
            TinyBuilder builder = new TinyBuilder(this.pipe);
            builder.setStatistics(Statistics.TEMPORARY_TREE_STATISTICS);
            TreeReceiver receiver = new TreeReceiver(builder);
            EventIteratorToReceiver.copy(sub, receiver);
            return builder.getCurrentRoot();
        }
        throw new IllegalStateException(pe.getClass().getName());
    }

    public void close() {
    }

    public SequenceIterator getAnother() throws XPathException {
        throw new UnsupportedOperationException("getAnother");
    }

    public int getProperties() {
        return 0;
    }

    private static class SubtreeIterator
    implements EventIterator {
        private int level = 0;
        private EventIterator base;
        private PullEvent first;

        public SubtreeIterator(EventIterator base, PullEvent first) {
            this.base = base;
            this.first = first;
        }

        public PullEvent next() throws XPathException {
            if (this.first != null) {
                PullEvent pe = this.first;
                this.first = null;
                return pe;
            }
            if (this.level < 0) {
                return null;
            }
            PullEvent pe = this.base.next();
            if (pe instanceof StartElementEvent || pe instanceof StartDocumentEvent) {
                ++this.level;
            } else if (pe instanceof EndElementEvent || pe instanceof EndDocumentEvent) {
                --this.level;
            }
            return pe;
        }

        public boolean isFlatSequence() {
            return this.base.isFlatSequence();
        }
    }
}

