/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openid.appauth.Preconditions;
import net.openid.appauth.internal.Logger;

public final class UriUtil {
    private UriUtil() {
        throw new IllegalStateException("This type is not intended to be instantiated");
    }

    public static Uri parseUriIfAvailable(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        return Uri.parse((String)uri);
    }

    public static void appendQueryParameterIfNotNull(@NonNull Uri.Builder uriBuilder, @NonNull String paramName, @Nullable Object value) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        if (valueStr == null) {
            return;
        }
        uriBuilder.appendQueryParameter(paramName, value.toString());
    }

    public static Long getLongQueryParameter(@NonNull Uri uri, @NonNull String param) {
        String valueStr = uri.getQueryParameter(param);
        if (valueStr != null) {
            return Long.parseLong(valueStr);
        }
        return null;
    }

    public static List<Bundle> toCustomTabUriBundle(Uri[] uris, int startIndex) {
        Preconditions.checkArgument(startIndex >= 0, "startIndex must be positive");
        if (uris == null || uris.length <= startIndex) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> uriBundles = new ArrayList<Bundle>(uris.length - startIndex);
        for (int i = startIndex; i < uris.length; ++i) {
            if (uris[i] == null) {
                Logger.warn("Null URI in possibleUris list - ignoring", new Object[0]);
                continue;
            }
            Bundle uriBundle = new Bundle();
            uriBundle.putParcelable("android.support.customtabs.otherurls.URL", (Parcelable)uris[i]);
            uriBundles.add(uriBundle);
        }
        return uriBundles;
    }

    @NonNull
    public static String formUrlEncode(@Nullable Map<String, String> parameters) {
        if (parameters == null) {
            return "";
        }
        ArrayList<String> queryParts = new ArrayList<String>();
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            queryParts.add(param.getKey() + "=" + UriUtil.formUrlEncodeValue(param.getValue()));
        }
        return TextUtils.join((CharSequence)"&", queryParts);
    }

    @NonNull
    public static String formUrlEncodeValue(@NonNull String value) {
        Preconditions.checkNotNull(value);
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to encode using UTF-8");
        }
    }

    public static List<Pair<String, String>> formUrlDecode(String encoded) {
        if (TextUtils.isEmpty((CharSequence)encoded)) {
            return Collections.emptyList();
        }
        String[] parts = encoded.split("&");
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        for (String part : parts) {
            String[] paramAndValue = part.split("=");
            String param = paramAndValue[0];
            String encodedValue = paramAndValue[1];
            try {
                params.add((Pair<String, String>)Pair.create((Object)param, (Object)URLDecoder.decode(encodedValue, "utf-8")));
            }
            catch (UnsupportedEncodingException ex) {
                Logger.error("Unable to decode parameter, ignoring", ex);
            }
        }
        return params;
    }

    public static Map<String, String> formUrlDecodeUnique(String encoded) {
        List<Pair<String, String>> params = UriUtil.formUrlDecode(encoded);
        HashMap<String, String> uniqueParams = new HashMap<String, String>();
        for (Pair<String, String> param : params) {
            uniqueParams.put((String)param.first, (String)param.second);
        }
        return uniqueParams;
    }
}

