/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.openid.appauth.AdditionalParamsProcessor;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationServiceDiscovery;
import net.openid.appauth.Clock;
import net.openid.appauth.JsonUtil;
import net.openid.appauth.TokenRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class IdToken {
    private static final String KEY_ISSUER = "iss";
    private static final String KEY_SUBJECT = "sub";
    private static final String KEY_AUDIENCE = "aud";
    private static final String KEY_EXPIRATION = "exp";
    private static final String KEY_ISSUED_AT = "iat";
    private static final String KEY_NONCE = "nonce";
    private static final String KEY_AUTHORIZED_PARTY = "azp";
    private static final Long MILLIS_PER_SECOND = 1000L;
    private static final Long TEN_MINUTES_IN_SECONDS = 600L;
    private static final Set<String> BUILT_IN_CLAIMS = AdditionalParamsProcessor.builtInParams("iss", "sub", "aud", "exp", "iat", "nonce", "azp");
    @NonNull
    public final String issuer;
    @NonNull
    public final String subject;
    @NonNull
    public final List<String> audience;
    @NonNull
    public final Long expiration;
    @NonNull
    public final Long issuedAt;
    @Nullable
    public final String nonce;
    @Nullable
    public final String authorizedParty;
    @NonNull
    public final Map<String, Object> additionalClaims;

    @VisibleForTesting
    IdToken(@NonNull String issuer, @NonNull String subject, @NonNull List<String> audience, @NonNull Long expiration, @NonNull Long issuedAt) {
        this(issuer, subject, audience, expiration, issuedAt, null, null, Collections.emptyMap());
    }

    @VisibleForTesting
    IdToken(@NonNull String issuer, @NonNull String subject, @NonNull List<String> audience, @NonNull Long expiration, @NonNull Long issuedAt, @Nullable String nonce, @Nullable String authorizedParty) {
        this(issuer, subject, audience, expiration, issuedAt, nonce, authorizedParty, Collections.emptyMap());
    }

    IdToken(@NonNull String issuer, @NonNull String subject, @NonNull List<String> audience, @NonNull Long expiration, @NonNull Long issuedAt, @Nullable String nonce, @Nullable String authorizedParty, @NonNull Map<String, Object> additionalClaims) {
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.expiration = expiration;
        this.issuedAt = issuedAt;
        this.nonce = nonce;
        this.authorizedParty = authorizedParty;
        this.additionalClaims = additionalClaims;
    }

    private static JSONObject parseJwtSection(String section) throws JSONException {
        byte[] decodedSection = Base64.decode((String)section, (int)8);
        String jsonString = new String(decodedSection);
        return new JSONObject(jsonString);
    }

    static IdToken from(String token) throws JSONException, IdTokenException {
        List<String> audience;
        String[] sections = token.split("\\.");
        if (sections.length <= 1) {
            throw new IdTokenException("ID token must have both header and claims section");
        }
        IdToken.parseJwtSection(sections[0]);
        JSONObject claims = IdToken.parseJwtSection(sections[1]);
        String issuer = JsonUtil.getString(claims, KEY_ISSUER);
        String subject = JsonUtil.getString(claims, KEY_SUBJECT);
        try {
            audience = JsonUtil.getStringList(claims, KEY_AUDIENCE);
        }
        catch (JSONException jsonEx) {
            audience = new ArrayList<String>();
            audience.add(JsonUtil.getString(claims, KEY_AUDIENCE));
        }
        Long expiration = claims.getLong(KEY_EXPIRATION);
        Long issuedAt = claims.getLong(KEY_ISSUED_AT);
        String nonce = JsonUtil.getStringIfDefined(claims, KEY_NONCE);
        String authorizedParty = JsonUtil.getStringIfDefined(claims, KEY_AUTHORIZED_PARTY);
        for (String key : BUILT_IN_CLAIMS) {
            claims.remove(key);
        }
        Map<String, Object> additionalClaims = JsonUtil.toMap(claims);
        return new IdToken(issuer, subject, audience, expiration, issuedAt, nonce, authorizedParty, additionalClaims);
    }

    @VisibleForTesting
    void validate(@NonNull TokenRequest tokenRequest, Clock clock) throws AuthorizationException {
        this.validate(tokenRequest, clock, false);
    }

    void validate(@NonNull TokenRequest tokenRequest, Clock clock, boolean skipIssuerHttpsCheck) throws AuthorizationException {
        String expectedNonce;
        String clientId;
        AuthorizationServiceDiscovery discoveryDoc = tokenRequest.configuration.discoveryDoc;
        if (discoveryDoc != null) {
            String expectedIssuer = discoveryDoc.getIssuer();
            if (!this.issuer.equals(expectedIssuer)) {
                throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Issuer mismatch"));
            }
            Uri issuerUri = Uri.parse((String)this.issuer);
            if (!skipIssuerHttpsCheck && !issuerUri.getScheme().equals("https")) {
                throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Issuer must be an https URL"));
            }
            if (TextUtils.isEmpty((CharSequence)issuerUri.getHost())) {
                throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Issuer host can not be empty"));
            }
            if (issuerUri.getFragment() != null || issuerUri.getQueryParameterNames().size() > 0) {
                throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Issuer URL should not containt query parameters or fragment components"));
            }
        }
        if (!this.audience.contains(clientId = tokenRequest.clientId) && !clientId.equals(this.authorizedParty)) {
            throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Audience mismatch"));
        }
        Long nowInSeconds = clock.getCurrentTimeMillis() / MILLIS_PER_SECOND;
        if (nowInSeconds > this.expiration) {
            throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("ID Token expired"));
        }
        if (Math.abs(nowInSeconds - this.issuedAt) > TEN_MINUTES_IN_SECONDS) {
            throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Issued at time is more than 10 minutes before or after the current time"));
        }
        if ("authorization_code".equals(tokenRequest.grantType) && !TextUtils.equals((CharSequence)this.nonce, (CharSequence)(expectedNonce = tokenRequest.nonce))) {
            throw AuthorizationException.fromTemplate(AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR, new IdTokenException("Nonce mismatch"));
        }
    }

    static class IdTokenException
    extends Exception {
        IdTokenException(String message) {
            super(message);
        }
    }
}

