/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

@Deprecated
public abstract class Timer {
    private float delay;
    private boolean repeat;
    private float acc;
    private boolean done;
    private boolean stopped;

    public Timer(float delay) {
        this(delay, false);
    }

    public Timer(float delay, boolean repeat) {
        this.delay = delay;
        this.repeat = repeat;
        this.acc = 0.0f;
    }

    public void update(float delta) {
        if (!this.done && !this.stopped) {
            this.acc += delta;
            if (this.acc >= this.delay) {
                this.acc -= this.delay;
                if (this.repeat) {
                    this.reset();
                } else {
                    this.done = true;
                }
                this.execute();
            }
        }
    }

    public void reset() {
        this.stopped = false;
        this.done = false;
        this.acc = 0.0f;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isRunning() {
        return !this.done && this.acc < this.delay && !this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public abstract void execute();

    public float getPercentageRemaining() {
        if (this.done) {
            return 100.0f;
        }
        if (this.stopped) {
            return 0.0f;
        }
        return 1.0f - (this.delay - this.acc) / this.delay;
    }

    public float getDelay() {
        return this.delay;
    }
}

