/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import java.util.Arrays;

public class IntBag {
    private int[] data;
    protected int size = 0;

    public IntBag() {
        this(64);
    }

    public IntBag(int capacity) {
        this.data = new int[capacity];
    }

    public int remove(int index) throws ArrayIndexOutOfBoundsException {
        int e = this.data[index];
        this.data[index] = this.data[--this.size];
        this.data[this.size] = 0;
        return e;
    }

    public int indexOf(int e) {
        for (int i = 0; this.size > i; ++i) {
            if (e != this.data[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int e) {
        for (int i = 0; this.size > i; ++i) {
            if (e != this.data[i]) continue;
            return true;
        }
        return false;
    }

    public int get(int index) throws ArrayIndexOutOfBoundsException {
        return this.data[index];
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public boolean isIndexWithinBounds(int index) {
        return index < this.getCapacity();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(int e) {
        if (this.size == this.data.length) {
            this.grow();
        }
        this.data[this.size++] = e;
    }

    public void set(int index, int e) {
        if (index >= this.data.length) {
            this.grow(index * 7 / 4 + 1);
        }
        this.size = Math.max(this.size, index + 1);
        this.data[index] = e;
    }

    private void grow() {
        int newCapacity = this.data.length * 7 / 4 + 1;
        this.grow(newCapacity);
    }

    private void grow(int newCapacity) throws ArrayIndexOutOfBoundsException {
        int[] oldData = this.data;
        this.data = new int[newCapacity];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    public void ensureCapacity(int index) {
        if (index >= this.data.length) {
            this.grow(index);
        }
    }

    public void clear() {
        Arrays.fill(this.data, 0, this.size, 0);
        this.size = 0;
    }

    public int[] getData() {
        return this.data;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBag intBag = (IntBag)o;
        return this.size == intBag.size() && Arrays.equals(this.data, intBag.data);
    }

    public int hashCode() {
        int hash = 0;
        int s = this.size;
        for (int i = 0; s > i; ++i) {
            hash = 127 * hash + this.data[i];
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IntBag(");
        for (int i = 0; this.size > i; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

