/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.utils;

import com.artemis.utils.ImmutableBag;
import com.artemis.utils.Sort;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Bag<E>
implements ImmutableBag<E> {
    E[] data;
    protected int size = 0;
    private BagIterator it;

    public Bag() {
        this(64);
    }

    public Bag(int capacity) {
        this.data = new Object[capacity];
    }

    public E remove(int index) throws ArrayIndexOutOfBoundsException {
        E e = this.data[index];
        this.data[index] = this.data[--this.size];
        this.data[this.size] = null;
        return e;
    }

    public void sort(Comparator<E> comparator) {
        Sort.instance().sort(this, comparator);
    }

    public E removeLast() {
        if (this.size > 0) {
            E e = this.data[--this.size];
            this.data[this.size] = null;
            return e;
        }
        return null;
    }

    public boolean remove(E e) {
        for (int i = 0; i < this.size; ++i) {
            E e2 = this.data[i];
            if (!e.equals(e2)) continue;
            this.data[i] = this.data[--this.size];
            this.data[this.size] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(E e) {
        for (int i = 0; this.size > i; ++i) {
            if (!e.equals(this.data[i])) continue;
            return true;
        }
        return false;
    }

    public boolean removeAll(ImmutableBag<E> bag) {
        boolean modified = false;
        int s = bag.size();
        block0: for (int i = 0; s > i; ++i) {
            E e1 = bag.get(i);
            for (int j = 0; j < this.size; ++j) {
                E e2 = this.data[j];
                if (!e1.equals(e2)) continue;
                this.remove(j);
                --j;
                modified = true;
                continue block0;
            }
        }
        return modified;
    }

    @Override
    public E get(int index) throws ArrayIndexOutOfBoundsException {
        return this.data[index];
    }

    public E safeGet(int index) {
        if (index >= this.data.length) {
            this.grow(index * 7 / 4 + 1);
        }
        return this.data[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public boolean isIndexWithinBounds(int index) {
        return index < this.getCapacity();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(E e) {
        if (this.size == this.data.length) {
            this.grow();
        }
        this.data[this.size++] = e;
    }

    public void set(int index, E e) {
        if (index >= this.data.length) {
            this.grow(index * 7 / 4 + 1);
        }
        this.size = Math.max(this.size, index + 1);
        this.data[index] = e;
    }

    private void grow() {
        int newCapacity = this.data.length * 7 / 4 + 1;
        this.grow(newCapacity);
    }

    private void grow(int newCapacity) throws ArrayIndexOutOfBoundsException {
        E[] oldData = this.data;
        this.data = new Object[newCapacity];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    public void ensureCapacity(int index) {
        if (index >= this.data.length) {
            this.grow(index);
        }
    }

    public void clear() {
        Arrays.fill(this.data, 0, this.size, null);
        this.size = 0;
    }

    public void fastClear() {
        this.data = new Object[this.data.length];
        this.size = 0;
    }

    public void addAll(ImmutableBag<E> items) {
        int s = items.size();
        for (int i = 0; s > i; ++i) {
            this.add(items.get(i));
        }
    }

    public Object[] getData() {
        return this.data;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.it == null) {
            this.it = new BagIterator();
        }
        this.it.validCursorPos = false;
        this.it.cursor = 0;
        return this.it;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bag(");
        for (int i = 0; this.size > i; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.data[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bag bag = (Bag)o;
        return this.size == bag.size() && Arrays.equals(this.data, bag.data);
    }

    public int hashCode() {
        int hash = 0;
        int s = this.size;
        for (int i = 0; s > i; ++i) {
            hash = 127 * hash + this.data[i].hashCode();
        }
        return hash;
    }

    private final class BagIterator
    implements Iterator<E> {
        private int cursor;
        private boolean validCursorPos;

        private BagIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < Bag.this.size;
        }

        @Override
        public E next() throws NoSuchElementException {
            if (this.cursor == Bag.this.size) {
                throw new NoSuchElementException("Iterated past last element");
            }
            Object e = Bag.this.data[this.cursor++];
            this.validCursorPos = true;
            return e;
        }

        @Override
        public void remove() throws IllegalStateException {
            if (!this.validCursorPos) {
                throw new IllegalStateException();
            }
            this.validCursorPos = false;
            Bag.this.remove(--this.cursor);
        }
    }
}

