/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.systems;

import com.artemis.Aspect;
import com.artemis.EntitySystem;

public abstract class IntervalEntitySystem
extends EntitySystem {
    protected float acc;
    private final float interval;
    private float intervalDelta;

    public IntervalEntitySystem(Aspect.Builder aspect, float interval) {
        super(aspect);
        this.interval = interval;
    }

    @Override
    protected boolean checkProcessing() {
        this.acc += this.getTimeDelta();
        if (this.acc >= this.interval) {
            this.acc -= this.interval;
            this.intervalDelta = this.acc - this.intervalDelta;
            return true;
        }
        return false;
    }

    protected float getIntervalDelta() {
        return this.interval + this.intervalDelta;
    }

    protected float getTimeDelta() {
        return this.world.getDelta();
    }
}

