/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.systems;

import com.artemis.Aspect;
import com.artemis.Entity;
import com.artemis.EntitySystem;
import com.artemis.World;
import com.artemis.utils.IntBag;

public abstract class DelayedEntityProcessingSystem
extends EntitySystem {
    private float delay;
    private boolean running;
    private float acc;
    private Entity flyweight;

    public DelayedEntityProcessingSystem(Aspect.Builder aspect) {
        super(aspect);
    }

    @Override
    protected void setWorld(World world) {
        super.setWorld(world);
        this.flyweight = this.createFlyweightEntity();
    }

    @Override
    protected final void processSystem() {
        IntBag actives = this.subscription.getEntities();
        int processed = actives.size();
        if (processed == 0) {
            this.stop();
            return;
        }
        this.delay = Float.MAX_VALUE;
        int[] array = actives.getData();
        Entity e = this.flyweight;
        for (int i = 0; processed > i; ++i) {
            e.id = array[i];
            this.processDelta(e, this.acc);
            float remaining = this.getRemainingDelay(e);
            if (remaining <= 0.0f) {
                this.processExpired(e);
                continue;
            }
            this.offerDelay(remaining);
        }
        this.acc = 0.0f;
    }

    @Override
    protected void inserted(int entityId) {
        Entity entity = this.world.getEntity(entityId);
        float remainingDelay = this.getRemainingDelay(entity);
        this.processDelta(entity, -this.acc);
        if (remainingDelay > 0.0f) {
            this.offerDelay(remainingDelay);
        }
    }

    protected abstract float getRemainingDelay(Entity var1);

    @Override
    protected final boolean checkProcessing() {
        if (this.running) {
            this.acc += this.getTimeDelta();
            return this.acc >= this.delay;
        }
        return false;
    }

    protected float getTimeDelta() {
        return this.world.getDelta();
    }

    protected abstract void processDelta(Entity var1, float var2);

    protected abstract void processExpired(Entity var1);

    @Deprecated
    public void restart(float delay) {
        this.delay = delay;
        this.acc = 0.0f;
        this.running = true;
    }

    public void offerDelay(float offeredDelay) {
        if (!this.running) {
            this.running = true;
            this.delay = offeredDelay;
        } else {
            this.delay = Math.min(this.delay, offeredDelay);
        }
    }

    public float getInitialTimeDelay() {
        return this.delay;
    }

    public float getRemainingTimeUntilProcessing() {
        if (this.running) {
            return this.delay - this.acc;
        }
        return 0.0f;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
        this.acc = 0.0f;
    }
}

