/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Manager;
import com.artemis.World;
import com.artemis.annotations.Wire;
import com.artemis.io.SaveFileFormat;
import com.artemis.utils.IntBag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

@Wire
public class WorldSerializationManager
extends Manager {
    private static final String TAG = WorldSerializationManager.class.getSimpleName();
    private ArtemisSerializer<?> backend;
    public boolean alwaysLoadStreamMemory = true;

    @Override
    protected void initialize() {
    }

    public void setSerializer(ArtemisSerializer<?> backend) {
        this.backend = backend;
    }

    public <T extends SaveFileFormat> T load(InputStream is, Class<T> format) {
        if (this.alwaysLoadStreamMemory || !is.markSupported()) {
            try {
                int read;
                byte[] buf = new byte[32768];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                is = new ByteArrayInputStream(baos.toByteArray());
                baos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying inputstream", e);
            }
        }
        return (T)this.backend.load(is, format);
    }

    public void save(Writer writer, SaveFileFormat format) {
        if (this.backend == null) {
            throw new RuntimeException("Missing ArtemisSerializer, see #setBackend.");
        }
        this.world.inject(format);
        this.backend.save(writer, format);
    }

    public static abstract class ArtemisSerializer<T> {
        protected World world;

        protected ArtemisSerializer(World world) {
            this.world = world;
        }

        protected final void save(Writer writer, IntBag entities) {
            this.save(writer, new SaveFileFormat(entities));
        }

        public abstract ArtemisSerializer register(Class<?> var1, T var2);

        protected abstract void save(Writer var1, SaveFileFormat var2);

        protected abstract <T extends SaveFileFormat> T load(InputStream var1, Class<T> var2);
    }
}

