/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Entity;
import com.artemis.Manager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TagManager
extends Manager {
    private final Map<String, Entity> entitiesByTag = new HashMap<String, Entity>();
    private final Map<Entity, String> tagsByEntity = new HashMap<Entity, String>();
    private Entity flyweight;

    public void register(String tag, Entity e) {
        this.entitiesByTag.put(tag, e);
        this.tagsByEntity.put(e, tag);
    }

    public void unregister(String tag) {
        this.tagsByEntity.remove(this.entitiesByTag.remove(tag));
    }

    public boolean isRegistered(String tag) {
        return this.entitiesByTag.containsKey(tag);
    }

    public Entity getEntity(String tag) {
        return this.entitiesByTag.get(tag);
    }

    public String getTag(Entity entity) {
        return this.tagsByEntity.get(entity);
    }

    public Collection<String> getRegisteredTags() {
        return this.tagsByEntity.values();
    }

    @Override
    public void deleted(int entityId) {
        this.flyweight.id = entityId;
        String removedTag = this.tagsByEntity.remove(this.flyweight);
        if (removedTag != null) {
            this.entitiesByTag.remove(removedTag);
        }
    }

    @Override
    protected void initialize() {
        this.flyweight = Entity.createFlyweight(this.world);
    }
}

