/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Entity;
import com.artemis.Manager;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import java.util.HashMap;
import java.util.Map;

public class PlayerManager
extends Manager {
    private final Map<Entity, String> playerByEntity = new HashMap<Entity, String>();
    private final Map<String, Bag<Entity>> entitiesByPlayer = new HashMap<String, Bag<Entity>>();
    private Entity flyweight;

    public void setPlayer(Entity e, String player) {
        this.playerByEntity.put(e, player);
        Bag<Entity> entities = this.entitiesByPlayer.get(player);
        if (entities == null) {
            entities = new Bag();
            this.entitiesByPlayer.put(player, entities);
        }
        entities.add(e);
    }

    public ImmutableBag<Entity> getEntitiesOfPlayer(String player) {
        Bag<Entity> entities = this.entitiesByPlayer.get(player);
        if (entities == null) {
            entities = new Bag();
        }
        return entities;
    }

    public void removeFromPlayer(Entity e) {
        Bag<Entity> entities;
        String player = this.playerByEntity.get(e);
        if (player != null && (entities = this.entitiesByPlayer.get(player)) != null) {
            entities.remove(e);
        }
    }

    public String getPlayer(Entity e) {
        return this.playerByEntity.get(e);
    }

    @Override
    protected void initialize() {
        this.flyweight = Entity.createFlyweight(this.world);
    }

    @Override
    public void deleted(int entityId) {
        this.flyweight.id = entityId;
        this.removeFromPlayer(this.flyweight);
    }
}

