/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.managers;

import com.artemis.Entity;
import com.artemis.Manager;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import java.util.HashMap;
import java.util.Map;

public class GroupManager
extends Manager {
    private static final ImmutableBag<String> EMPTY_BAG = new Bag<String>();
    private final Map<String, Bag<Entity>> entitiesByGroup = new HashMap<String, Bag<Entity>>();
    private final Map<Entity, Bag<String>> groupsByEntity = new HashMap<Entity, Bag<String>>();
    private Entity flyweight;

    @Override
    protected void initialize() {
        this.flyweight = Entity.createFlyweight(this.world);
    }

    public void add(Entity e, String group) {
        Bag<String> groups;
        Bag<Entity> entities = this.entitiesByGroup.get(group);
        if (entities == null) {
            entities = new Bag();
            this.entitiesByGroup.put(group, entities);
        }
        if (!entities.contains(e)) {
            entities.add(e);
        }
        if ((groups = this.groupsByEntity.get(e)) == null) {
            groups = new Bag();
            this.groupsByEntity.put(e, groups);
        }
        if (!groups.contains(group)) {
            groups.add(group);
        }
    }

    public void remove(Entity e, String group) {
        Bag<String> groups;
        Bag<Entity> entities = this.entitiesByGroup.get(group);
        if (entities != null) {
            entities.remove(e);
        }
        if ((groups = this.groupsByEntity.get(e)) != null) {
            groups.remove(group);
            if (groups.size() == 0) {
                this.groupsByEntity.remove(e);
            }
        }
    }

    public void removeFromAllGroups(Entity e) {
        Bag<String> groups = this.groupsByEntity.get(e);
        if (groups == null) {
            return;
        }
        int s = groups.size();
        for (int i = 0; s > i; ++i) {
            Bag<Entity> entities = this.entitiesByGroup.get(groups.get(i));
            if (entities == null) continue;
            entities.remove(e);
        }
        this.groupsByEntity.remove(e);
    }

    public ImmutableBag<Entity> getEntities(String group) {
        Bag<Entity> entities = this.entitiesByGroup.get(group);
        if (entities == null) {
            entities = new Bag();
            this.entitiesByGroup.put(group, entities);
        }
        return entities;
    }

    public ImmutableBag<String> getGroups(Entity e) {
        Bag<String> groups = this.groupsByEntity.get(e);
        return groups != null ? groups : EMPTY_BAG;
    }

    public boolean isInAnyGroup(Entity e) {
        return this.getGroups(e).size() > 0;
    }

    public boolean isInGroup(Entity e, String group) {
        Bag<String> bag;
        if (group != null && (bag = this.groupsByEntity.get(e)) != null) {
            Object[] groups = bag.getData();
            int s = bag.size();
            for (int i = 0; s > i; ++i) {
                String g = (String)groups[i];
                if (!group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void deleted(int entityId) {
        this.flyweight.id = entityId;
        this.removeFromAllGroups(this.flyweight);
    }
}

