/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentType;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.annotations.EntityId;
import com.artemis.io.EntityReference;
import com.artemis.utils.Bag;
import com.artemis.utils.IntBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class ReferenceTracker {
    Bag<EntityReference> referenced = new Bag();
    private Set<Class<?>> referencingTypes = new HashSet();
    private Set<Field> referencingFields = new HashSet<Field>();

    ReferenceTracker() {
    }

    void inspectTypes(World world) {
        this.clear();
        ComponentManager cm = world.getComponentManager();
        for (ComponentType ct : cm.getComponentTypes()) {
            this.inspectType(ct.getType());
        }
    }

    void inspectTypes(Collection<Class<? extends Component>> types) {
        this.clear();
        for (Class<? extends Component> component : types) {
            this.inspectType(component);
        }
    }

    private void clear() {
        this.referencingFields.clear();
        this.referencingTypes.clear();
        this.referenced.clear();
    }

    private void inspectType(Class<?> type) {
        Field[] fields = ClassReflection.getDeclaredFields(type);
        for (int i = 0; fields.length > i; ++i) {
            Field f = fields[i];
            if (!this.isReferencingEntity(f) || this.referencingFields.contains(type)) continue;
            this.referencingFields.add(f);
            this.referencingTypes.add(type);
            this.referenced.add(new EntityReference(type, f));
        }
    }

    void addEntityReferencingComponent(Component c) {
        Class<?> componentClass = c.getClass();
        if (!this.referencingTypes.contains(componentClass)) {
            return;
        }
        int s = this.referenced.size();
        for (int i = 0; s > i; ++i) {
            EntityReference ref = this.referenced.get(i);
            if (ref.componentType != componentClass) continue;
            ref.operations.add(c);
        }
    }

    void translate(Bag<Entity> translations) {
        for (EntityReference ref : this.referenced) {
            ref.translate(translations);
        }
        translations.clear();
    }

    EntityReference find(Class<?> componentType, String fieldName) {
        int s = this.referenced.size();
        for (int i = 0; s > i; ++i) {
            EntityReference ref = this.referenced.get(i);
            if (!ref.componentType.equals(componentType) || !ref.field.getName().equals(fieldName)) continue;
            return ref;
        }
        throw new RuntimeException(componentType.getSimpleName() + "." + fieldName);
    }

    private boolean isReferencingEntity(Field f) {
        boolean explicitEntityId = f.getDeclaredAnnotation(EntityId.class) != null;
        Class type = f.getType();
        return Entity.class == type || Bag.class == type || Integer.TYPE == type && explicitEntityId || IntBag.class == type && explicitEntityId;
    }
}

