/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.BaseSystem;
import com.artemis.ComponentMapper;
import com.artemis.EntityFactory;
import com.artemis.Manager;
import com.artemis.annotations.Mapper;
import com.artemis.annotations.Wire;
import com.artemis.injection.CachedClass;
import com.artemis.injection.CachedField;
import com.artemis.injection.ClassType;
import com.artemis.injection.WireType;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Field;
import com.artemis.utils.reflect.ReflectionException;
import java.util.HashMap;
import java.util.Map;

public class InjectionCache {
    private static final Map<Class<?>, CachedClass> classCache = new HashMap();
    private static final Map<Class<?>, ClassType> fieldClassTypeCache = new HashMap();
    private static final Map<Field, CachedField> namedWireCache = new HashMap<Field, CachedField>();
    private static final Map<Field, Class<?>> genericsCache = new HashMap();

    public CachedClass getCachedClass(Class<?> clazz) throws ReflectionException {
        CachedClass cachedClass = classCache.get(clazz);
        if (cachedClass == null) {
            cachedClass = new CachedClass(clazz);
            WireType wireType = cachedClass.wireType = ClassReflection.isAnnotationPresent(clazz, Wire.class) ? WireType.WIRE : WireType.IGNORED;
            if (cachedClass.wireType == WireType.WIRE) {
                Wire wireAnnotation;
                cachedClass.wireAnnotation = wireAnnotation = ClassReflection.getAnnotation(clazz, Wire.class);
                cachedClass.failOnNull = wireAnnotation.failOnNull();
                cachedClass.injectInherited = wireAnnotation.injectInherited();
            }
            classCache.put(clazz, cachedClass);
        }
        return cachedClass;
    }

    public CachedField getCachedField(Field field) {
        CachedField cachedField = namedWireCache.get(field);
        if (cachedField == null) {
            if (field.isAnnotationPresent(Wire.class)) {
                Wire wire = field.getAnnotation(Wire.class);
                cachedField = new CachedField(field, WireType.WIRE, wire.name());
            } else {
                cachedField = field.isAnnotationPresent(Mapper.class) ? new CachedField(field, WireType.MAPPER, null) : new CachedField(field, WireType.IGNORED, null);
            }
            namedWireCache.put(field, cachedField);
        }
        return cachedField;
    }

    public ClassType getFieldClassType(Class<?> fieldType) {
        ClassType injectionType = fieldClassTypeCache.get(fieldType);
        if (injectionType == null) {
            injectionType = ClassReflection.isAssignableFrom(ComponentMapper.class, fieldType) ? ClassType.MAPPER : (ClassReflection.isAssignableFrom(BaseSystem.class, fieldType) ? ClassType.SYSTEM : (ClassReflection.isAssignableFrom(Manager.class, fieldType) ? ClassType.MANAGER : (ClassReflection.isAssignableFrom(EntityFactory.class, fieldType) ? ClassType.FACTORY : ClassType.CUSTOM)));
            fieldClassTypeCache.put(fieldType, injectionType);
        }
        return injectionType;
    }

    public Class<?> getGenericType(Field field) {
        Class genericsType = genericsCache.get(field);
        if (genericsType == null) {
            genericsType = field.getElementType(0);
            genericsCache.put(field, genericsType);
        }
        return genericsType;
    }
}

