/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.injection;

import com.artemis.BaseSystem;
import com.artemis.ComponentMapper;
import com.artemis.Manager;
import com.artemis.World;
import com.artemis.injection.ClassType;
import com.artemis.injection.FieldResolver;
import com.artemis.injection.InjectionCache;
import com.artemis.injection.UseInjectionCache;
import com.artemis.utils.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;

public class ArtemisFieldResolver
implements FieldResolver,
UseInjectionCache {
    private World world;
    private InjectionCache cache;
    private Map<Class<?>, Class<?>> systems = new IdentityHashMap();
    private Map<Class<?>, Class<?>> managers = new IdentityHashMap();

    @Override
    public void initialize(World world) {
        Class<?> clazz;
        Class<?> origin;
        this.world = world;
        for (BaseSystem es : world.getSystems()) {
            clazz = origin = es.getClass();
            do {
                this.systems.put(clazz, origin);
            } while ((clazz = clazz.getSuperclass()) != Object.class);
        }
        for (Manager manager : world.getManagers()) {
            clazz = origin = manager.getClass();
            do {
                this.managers.put(clazz, origin);
            } while ((clazz = clazz.getSuperclass()) != Object.class);
        }
    }

    @Override
    public Object resolve(Class<?> fieldType, Field field) {
        ClassType injectionType = this.cache.getFieldClassType(fieldType);
        switch (injectionType) {
            case MAPPER: {
                return this.getComponentMapper(field);
            }
            case SYSTEM: {
                return this.world.getSystem(this.systems.get(fieldType));
            }
            case MANAGER: {
                return this.world.getManager(this.managers.get(fieldType));
            }
            case FACTORY: {
                return this.world.createFactory(fieldType);
            }
        }
        return null;
    }

    private ComponentMapper<?> getComponentMapper(Field field) {
        Class<?> mapperType = this.cache.getGenericType(field);
        return this.world.getMapper(mapperType);
    }

    @Override
    public void setCache(InjectionCache cache) {
        this.cache = cache;
    }
}

