/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Archetype;
import com.artemis.ArtemisMultiException;
import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.BasicComponentMapper;
import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentMapper;
import com.artemis.Entity;
import com.artemis.EntityEditPool;
import com.artemis.EntityFactory;
import com.artemis.EntityManager;
import com.artemis.InvocationStrategy;
import com.artemis.Manager;
import com.artemis.MundaneWireException;
import com.artemis.SystemInvocationStrategy;
import com.artemis.WorldConfiguration;
import com.artemis.injection.CachedInjector;
import com.artemis.injection.Injector;
import com.artemis.managers.UuidEntityManager;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Constructor;
import com.artemis.utils.reflect.ReflectionException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;

public class World {
    private final EntityManager em;
    private final ComponentManager cm;
    private final AspectSubscriptionManager am;
    public float delta;
    final BitSet added;
    final BitSet changed;
    final BitSet disabled;
    final BitSet enabled;
    final BitSet deleted;
    final Map<Class<? extends Manager>, Manager> managers;
    final Bag<Manager> managersBag;
    final Map<Class<?>, BaseSystem> systems;
    private final Bag<BaseSystem> systemsBag;
    private boolean registerUuids;
    private Injector injector;
    final EntityEditPool editPool = new EntityEditPool(this);
    private SystemInvocationStrategy invocationStrategy;
    private WorldConfiguration configuration;

    public World() {
        this(new WorldConfiguration());
    }

    @Deprecated
    public World(int expectedEntityCount) {
        this(new WorldConfiguration());
    }

    public World(WorldConfiguration configuration) {
        this.configuration = configuration;
        this.managers = new IdentityHashMap<Class<? extends Manager>, Manager>();
        this.managersBag = configuration.managers;
        this.systems = new IdentityHashMap();
        this.systemsBag = configuration.systems;
        this.added = new BitSet();
        this.changed = new BitSet();
        this.deleted = new BitSet();
        this.enabled = new BitSet();
        this.disabled = new BitSet();
        this.cm = new ComponentManager(configuration.expectedEntityCount());
        this.em = new EntityManager(configuration.expectedEntityCount());
        this.am = new AspectSubscriptionManager();
        this.injector = configuration.injector;
        if (this.injector == null) {
            this.injector = new CachedInjector();
        }
        configuration.initialize(this, this.injector, this.am);
        boolean bl = this.registerUuids = this.managers.get(UuidEntityManager.class) != null;
        if (this.invocationStrategy == null) {
            this.setInvocationStrategy(new InvocationStrategy());
        }
    }

    @Deprecated
    public void initialize() {
    }

    public void inject(Object target) {
        this.inject(target, true);
    }

    public void inject(Object target, boolean failIfWireAnnotationIsMissing) {
        boolean injectable = this.injector.isInjectable(target);
        if (!injectable && failIfWireAnnotationIsMissing) {
            throw new MundaneWireException(target.getClass().getName() + " must be annotated with @Wire");
        }
        if (injectable) {
            this.injector.inject(target);
        }
    }

    public void dispose() {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Manager manager : this.managersBag) {
            try {
                manager.dispose();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        for (BaseSystem system : this.systemsBag) {
            try {
                system.dispose();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new ArtemisMultiException(exceptions);
        }
    }

    public <T extends EntityFactory> T createFactory(Class<?> factory) {
        if (!factory.isInterface()) {
            throw new MundaneWireException("Expected interface for type: " + factory);
        }
        String impl = factory.getName() + "Impl";
        try {
            Class implClass = ClassReflection.forName(impl);
            Constructor constructor = ClassReflection.getConstructor(implClass, World.class);
            return (T)((EntityFactory)constructor.newInstance(this));
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityManager getEntityManager() {
        return this.em;
    }

    public ComponentManager getComponentManager() {
        return this.cm;
    }

    @Deprecated
    public final <T extends Manager> T setManager(T manager) {
        throw new MundaneWireException("use WorldConfiguration#setManager");
    }

    public <T extends Manager> T getManager(Class<T> managerType) {
        return (T)this.managers.get(managerType);
    }

    public ImmutableBag<Manager> getManagers() {
        return this.managersBag;
    }

    @Deprecated
    public void deleteManager(Manager manager) {
        this.managers.remove(manager.getClass());
        this.managersBag.remove(manager);
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float delta) {
        this.delta = delta;
    }

    @Deprecated
    public void addEntity(Entity e) {
    }

    @Deprecated
    public void changedEntity(Entity e) {
    }

    public void deleteEntity(Entity e) {
        e.edit().deleteEntity();
    }

    public void deleteEntity(int entityId) {
        this.deleteEntity(this.em.getEntity(entityId));
    }

    @Deprecated
    public void enable(Entity e) {
        if (this.disabled.get(e.id)) {
            this.disabled.set(e.id, false);
        }
        this.enabled.set(e.id, true);
    }

    @Deprecated
    public void disable(Entity e) {
        if (this.enabled.get(e.id)) {
            this.enabled.set(e.id, false);
        }
        this.disabled.set(e.id);
    }

    public Entity createEntity() {
        Entity e = this.em.createEntityInstance();
        e.edit();
        return e;
    }

    public Entity createEntity(Archetype archetype) {
        Entity e = this.em.createEntityInstance(archetype);
        this.cm.addComponents(e, archetype);
        this.added.set(e.id);
        return e;
    }

    public Entity createEntity(UUID uuid) {
        Entity entity = this.em.createEntityInstance();
        entity.setUuid(uuid);
        entity.edit();
        return entity;
    }

    public Entity getEntity(int entityId) {
        return this.em.getEntity(entityId);
    }

    public ImmutableBag<BaseSystem> getSystems() {
        return this.systemsBag;
    }

    @Deprecated
    public <T extends BaseSystem> T setSystem(T system) {
        throw new MundaneWireException("use WorldConfiguration#setSystem");
    }

    @Deprecated
    public <T extends BaseSystem> T setSystem(T system, boolean passive) {
        throw new MundaneWireException("use WorldConfiguration#setSystem");
    }

    @Deprecated
    public void deleteSystem(BaseSystem system) {
    }

    public <T extends BaseSystem> T getSystem(Class<T> type) {
        return (T)this.systems.get(type);
    }

    public void setInvocationStrategy(SystemInvocationStrategy invocationStrategy) {
        this.invocationStrategy = invocationStrategy;
        invocationStrategy.setWorld(this);
    }

    public void process() {
        this.updateEntityStates();
        this.em.clean();
        this.cm.clean();
        this.invocationStrategy.process(this.systemsBag);
    }

    void updateEntityStates() {
        while (this.added.cardinality() > 0 || this.changed.cardinality() > 0) {
            this.am.process(this.added, this.changed, this.deleted);
        }
        while (this.editPool.processEntities()) {
            this.am.process(this.added, this.changed, this.deleted);
            this.am.process(this.added, this.enabled, this.disabled);
        }
    }

    boolean hasUuidManager() {
        return this.registerUuids;
    }

    public <T extends Component> ComponentMapper<T> getMapper(Class<T> type) {
        return BasicComponentMapper.getFor(type, this);
    }
}

