/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.ComponentManager;
import com.artemis.ComponentMapper;
import com.artemis.ComponentType;
import com.artemis.PackedComponent;
import com.artemis.World;
import java.util.BitSet;

class PackedComponentMapper<A extends PackedComponent>
extends ComponentMapper<A> {
    private final Class<A> componentType;
    private final PackedComponent component;
    private final BitSet owners;
    private boolean newInstanceWithWorld = false;
    private World world;

    private PackedComponentMapper(Class<A> componentType, World world) {
        this.world = world;
        ComponentManager cm = world.getComponentManager();
        ComponentType type = cm.typeFactory.getTypeFor(componentType);
        this.newInstanceWithWorld = type.packedHasWorldConstructor;
        this.owners = cm.getPackedComponentOwners(type);
        this.componentType = componentType;
        this.component = this.newInstance();
    }

    static PackedComponentMapper<PackedComponent> create(Class<PackedComponent> type, World world) {
        return new PackedComponentMapper<PackedComponent>(type, world);
    }

    @Override
    public A get(int entityId) throws ArrayIndexOutOfBoundsException {
        this.component.forEntity(entityId);
        return (A)this.component;
    }

    @Override
    public A getSafe(int entityId) {
        return (A)(this.has(entityId) ? this.get(entityId) : null);
    }

    @Override
    public boolean has(int entityId) {
        return this.owners.get(entityId);
    }

    @Override
    public A get(int entityId, boolean forceNewInstance) throws ArrayIndexOutOfBoundsException {
        if (forceNewInstance) {
            A c = this.newInstance();
            ((PackedComponent)c).forEntity(entityId);
            return c;
        }
        return (A)this.get(entityId);
    }

    @Override
    public A getSafe(int entityId, boolean forceNewInstance) {
        if (this.has(entityId)) {
            return (A)this.get(entityId, forceNewInstance);
        }
        return null;
    }

    private A newInstance() {
        return (A)((PackedComponent)this.world.getComponentManager().newInstance(this.componentType, this.newInstanceWithWorld));
    }
}

