/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentTypeFactory;
import com.artemis.EntityTransmuter;
import com.artemis.World;
import java.util.BitSet;

public final class EntityTransmuterFactory {
    private final ComponentTypeFactory types;
    private final BitSet additions;
    private final BitSet removals;
    private World world;

    public EntityTransmuterFactory(World world) {
        this.world = world;
        this.types = world.getComponentManager().typeFactory;
        this.additions = new BitSet();
        this.removals = new BitSet();
    }

    public EntityTransmuterFactory add(Class<? extends Component> component) {
        int index = this.types.getIndexFor(component);
        this.additions.set(index, true);
        this.removals.set(index, false);
        return this;
    }

    public EntityTransmuterFactory remove(Class<? extends Component> component) {
        int index = this.types.getIndexFor(component);
        this.additions.set(index, false);
        this.removals.set(index, true);
        return this;
    }

    public EntityTransmuter build() {
        return new EntityTransmuter(this.world, this.additions, this.removals);
    }
}

