/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.ComponentManager;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.utils.Bag;
import java.util.BitSet;

public final class EntityTransmuter {
    private final World world;
    private final BitSet additions;
    private final BitSet removals;
    private final Bag<TransmuteOperation> operations;
    private final BitSet bs;

    EntityTransmuter(World world, BitSet additions, BitSet removals) {
        this.world = world;
        this.additions = additions;
        this.removals = removals;
        this.operations = new Bag();
        this.bs = new BitSet();
    }

    public void transmute(Entity e) {
        e = this.world.getEntity(e.id);
        TransmuteOperation operation = this.getOperation(e);
        operation.perform(e, this.world.getComponentManager());
        this.world.getEntityManager().setIdentity(e, operation);
        if (e.isActive()) {
            this.world.changed.set(e.id);
        } else {
            this.world.added.set(e.id);
        }
    }

    private TransmuteOperation getOperation(Entity e) {
        int compositionId;
        TransmuteOperation operation;
        if (this.world.editPool.isEdited(e)) {
            this.world.editPool.processAndRemove(e);
        }
        if ((operation = this.operations.safeGet(compositionId = e.getCompositionId())) == null) {
            operation = this.createOperation(e);
            this.operations.set(compositionId, operation);
        }
        return operation;
    }

    private TransmuteOperation createOperation(Entity e) {
        BitSet origin = e.getComponentBits();
        this.bs.clear();
        this.bs.or(origin);
        this.bs.or(this.additions);
        this.bs.andNot(this.removals);
        int compositionId = this.world.getEntityManager().compositionIdentity(this.bs);
        return new TransmuteOperation(compositionId, this.getAdditions(origin), this.getRemovals(origin));
    }

    private Bag<ComponentType> getAdditions(BitSet origin) {
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        Bag<ComponentType> types = new Bag<ComponentType>();
        int i = this.additions.nextSetBit(0);
        while (i >= 0) {
            if (!origin.get(i)) {
                types.add(tf.getTypeFor(i));
            }
            i = this.additions.nextSetBit(i + 1);
        }
        return types;
    }

    private Bag<ComponentType> getRemovals(BitSet origin) {
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        Bag<ComponentType> types = new Bag<ComponentType>();
        int i = this.removals.nextSetBit(0);
        while (i >= 0) {
            if (origin.get(i)) {
                types.add(tf.getTypeFor(i));
            }
            i = this.removals.nextSetBit(i + 1);
        }
        return types;
    }

    public String toString() {
        return "EntityTransmuter(add=" + this.additions + " remove=" + this.removals + ")";
    }

    static class TransmuteOperation {
        private Bag<ComponentType> additions;
        private Bag<ComponentType> removals;
        public final int compositionId;

        public TransmuteOperation(int compositionId, Bag<ComponentType> additions, Bag<ComponentType> removals) {
            this.compositionId = compositionId;
            this.additions = additions;
            this.removals = removals;
        }

        public void perform(Entity e, ComponentManager cm) {
            int i;
            int s = this.additions.size();
            for (i = 0; s > i; ++i) {
                cm.create(e, this.additions.get(i));
            }
            s = this.removals.size();
            for (i = 0; s > i; ++i) {
                cm.removeComponent(e, this.removals.get(i));
            }
        }

        public String toString() {
            String delim;
            StringBuilder sb = new StringBuilder();
            sb.append("TransmuteOperation(");
            if (this.additions.size() > 0) {
                sb.append("add={");
                delim = "";
                for (ComponentType ct : this.additions) {
                    sb.append(delim).append(ct.getType().getSimpleName());
                    delim = ", ";
                }
                sb.append("}");
            }
            if (this.removals.size() > 0) {
                if (this.additions.size() > 0) {
                    sb.append(" ");
                }
                sb.append("remove={");
                delim = "";
                for (ComponentType ct : this.removals) {
                    sb.append(delim).append(ct.getType().getSimpleName());
                    delim = ", ";
                }
                sb.append("}");
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

