/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.AspectSubscriptionManager;
import com.artemis.BaseSystem;
import com.artemis.Entity;
import com.artemis.EntitySubscription;
import com.artemis.World;
import com.artemis.utils.Bag;
import com.artemis.utils.ImmutableBag;
import com.artemis.utils.IntBag;

public abstract class EntitySystem
extends BaseSystem
implements EntitySubscription.SubscriptionListener {
    private final Aspect.Builder aspectConfiguration;
    protected EntitySubscription subscription;

    public EntitySystem(Aspect.Builder aspect) {
        if (aspect == null) {
            String error = "Aspect.Builder was null; to use systems which do not subscribe to entities, extend BaseSystem directly.";
            throw new NullPointerException(error);
        }
        this.aspectConfiguration = aspect;
    }

    @Override
    protected void setWorld(World world) {
        super.setWorld(world);
        this.subscription = this.getSubscription();
        this.subscription.addSubscriptionListener(this);
    }

    public EntitySubscription getSubscription() {
        AspectSubscriptionManager sm = this.world.getManager(AspectSubscriptionManager.class);
        return sm.get(this.aspectConfiguration);
    }

    @Override
    public void inserted(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.inserted(ids[i]);
        }
    }

    protected void inserted(int entityId) {
    }

    @Override
    public void removed(IntBag entities) {
        int[] ids = entities.getData();
        int s = entities.size();
        for (int i = 0; s > i; ++i) {
            this.removed(ids[i]);
        }
    }

    protected void removed(int entityId) {
    }

    @Deprecated
    public Bag<Entity> getActives(Bag<Entity> fillBag) {
        IntBag actives = this.subscription.getEntities();
        int[] array = actives.getData();
        int s = actives.size();
        for (int i = 0; s > i; ++i) {
            fillBag.add(this.world.getEntity(array[i]));
        }
        return fillBag;
    }

    @Deprecated
    protected final void check(Entity e) {
    }

    @Deprecated
    public final void added(Entity e) {
    }

    @Deprecated
    public final void added(ImmutableBag<Entity> entities) {
    }

    @Deprecated
    public final void changed(ImmutableBag<Entity> entities) {
    }

    @Deprecated
    public final void deleted(ImmutableBag<Entity> entities) {
    }

    @Deprecated
    public final void changed(Entity e) {
    }

    @Deprecated
    public final void deleted(Entity e) {
    }

    @Deprecated
    public final void disabled(Entity e) {
    }

    @Deprecated
    public final void enabled(Entity e) {
    }

    @Deprecated
    public ImmutableBag<Entity> getActives() {
        return this.getActives(new Bag<Entity>());
    }
}

