/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Entity;
import com.artemis.EntityEdit;
import com.artemis.EntityManager;
import com.artemis.WildBag;
import com.artemis.World;
import com.artemis.utils.Bag;
import java.util.BitSet;

final class EntityEditPool {
    private final Bag<EntityEdit> pool = new Bag();
    private final World world;
    private WildBag<EntityEdit> edited;
    private WildBag<EntityEdit> alternateEdited;
    private final BitSet editedIds;

    EntityEditPool(World world) {
        this.world = world;
        this.edited = new WildBag();
        this.alternateEdited = new WildBag();
        this.editedIds = new BitSet();
    }

    boolean isEdited(Entity e) {
        return this.editedIds.get(e.id);
    }

    void processAndRemove(Entity e) {
        this.editedIds.set(e.id, false);
        EntityEdit edit = this.findEntityEdit(e, true);
        this.world.getEntityManager().updateCompositionIdentity(edit);
    }

    EntityEdit obtainEditor(Entity entity) {
        if (this.editedIds.get(entity.getId())) {
            return this.findEntityEdit(entity, false);
        }
        EntityEdit edit = this.entityEdit();
        this.editedIds.set(entity.getId());
        this.edited.add(edit);
        edit.entity = entity;
        edit.hasBeenAddedToWorld = this.world.getEntityManager().isActive(entity.getId());
        BitSet bits = entity.getComponentBits();
        edit.componentBits.or(bits);
        return edit;
    }

    private EntityEdit entityEdit() {
        if (this.pool.isEmpty()) {
            return new EntityEdit(this.world);
        }
        EntityEdit edit = this.pool.removeLast();
        edit.componentBits.clear();
        edit.scheduledDeletion = false;
        return edit;
    }

    private EntityEdit findEntityEdit(Entity entity, boolean remove) {
        int last = this.edited.size() - 1;
        if (((EntityEdit)this.edited.get((int)last)).entity.id == entity.id) {
            return remove ? (EntityEdit)this.edited.remove(last) : (EntityEdit)this.edited.get(last);
        }
        Object[] data = this.edited.getData();
        for (int i = 0; last > i; ++i) {
            EntityEdit edit = (EntityEdit)data[i];
            if (!edit.entity.equals(entity)) continue;
            return remove ? (EntityEdit)this.edited.remove(i) : edit;
        }
        throw new RuntimeException();
    }

    boolean processEntities() {
        int size = this.edited.size();
        if (size == 0) {
            return false;
        }
        Object[] data = this.edited.getData();
        this.editedIds.clear();
        this.edited.setSize(0);
        this.swapEditBags();
        World w = this.world;
        EntityManager em = w.getEntityManager();
        for (int i = 0; size > i; ++i) {
            EntityEdit edit = (EntityEdit)data[i];
            em.updateCompositionIdentity(edit);
            EntityEditPool.addToPerformer(w, edit);
            this.pool.add(edit);
        }
        return true;
    }

    private static void addToPerformer(World w, EntityEdit edit) {
        if (edit.scheduledDeletion) {
            w.deleted.set(edit.entity.id);
        } else if (edit.hasBeenAddedToWorld) {
            w.changed.set(edit.entity.id);
        } else {
            w.added.set(edit.entity.id);
        }
    }

    private void swapEditBags() {
        WildBag<EntityEdit> tmp = this.edited;
        this.edited = this.alternateEdited;
        this.alternateEdited = tmp;
    }
}

