/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.InvalidComponentException;
import com.artemis.World;
import java.util.BitSet;

public final class EntityEdit {
    Entity entity;
    private World world;
    boolean hasBeenAddedToWorld;
    final BitSet componentBits;
    boolean scheduledDeletion;

    EntityEdit(World world) {
        this.world = world;
        this.componentBits = new BitSet();
    }

    public void deleteEntity() {
        this.scheduledDeletion = true;
    }

    public <T extends Component> T create(Class<T> componentKlazz) {
        ComponentManager componentManager = this.world.getComponentManager();
        T component = componentManager.create(this.entity, componentKlazz);
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        ComponentType componentType = tf.getTypeFor(componentKlazz);
        this.componentBits.set(componentType.getIndex());
        return component;
    }

    public EntityEdit add(Component component) {
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        return this.add(component, tf.getTypeFor(component.getClass()));
    }

    public EntityEdit add(Component component, ComponentType type) {
        if (type.getTaxonomy() != ComponentType.Taxonomy.BASIC) {
            throw new InvalidComponentException(component.getClass(), "Use EntityEdit#create(Class<Component>) for adding non-basic component types");
        }
        this.world.getComponentManager().addComponent(this.entity, type, component);
        this.componentBits.set(type.getIndex());
        return this;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EntityEdit remove(Component component) {
        return this.remove(component.getClass());
    }

    public EntityEdit remove(ComponentType type) {
        if (this.componentBits.get(type.getIndex())) {
            this.world.getComponentManager().removeComponent(this.entity, type);
            this.componentBits.clear(type.getIndex());
        }
        return this;
    }

    public EntityEdit remove(Class<? extends Component> type) {
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        return this.remove(tf.getTypeFor(type));
    }

    public String toString() {
        return "EntityEdit[" + this.entity.getId() + "]";
    }
}

