/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.EntityEdit;
import com.artemis.MundaneWireException;
import com.artemis.World;
import com.artemis.managers.UuidEntityManager;
import com.artemis.utils.Bag;
import java.util.BitSet;
import java.util.UUID;

public final class Entity {
    public int id;
    private final World world;

    protected Entity(World world, int id) {
        this(world, id, null);
    }

    protected Entity(World world, int id, UUID uuid) {
        this.world = world;
        this.id = id;
        if (uuid != null && world.hasUuidManager()) {
            world.getManager(UuidEntityManager.class).setUuid(this, uuid);
        }
    }

    public int getId() {
        return this.id;
    }

    public static Entity createFlyweight(World world) {
        return new Entity(world, -1);
    }

    protected BitSet getComponentBits() {
        return this.world.getEntityManager().componentBits(this.id);
    }

    public EntityEdit edit() {
        Entity entity = this.world.getEntity(this.id);
        if (entity == null) {
            entity = this;
        }
        return this.world.editPool.obtainEditor(entity);
    }

    public String toString() {
        return "Entity[" + this.id + "]";
    }

    @Deprecated
    public <T extends Component> T createComponent(Class<T> componentKlazz) {
        return this.edit().create(componentKlazz);
    }

    @Deprecated
    public Entity addComponent(Component component) {
        this.edit().add(component);
        return this;
    }

    @Deprecated
    public Entity addComponent(Component component, ComponentType type) {
        this.edit().add(component, type);
        return this;
    }

    @Deprecated
    public Entity removeComponent(Component component) {
        this.edit().remove(component);
        return this;
    }

    @Deprecated
    public Entity removeComponent(ComponentType type) {
        this.edit().remove(type);
        return this;
    }

    @Deprecated
    public Entity removeComponent(Class<? extends Component> type) {
        this.edit().remove(type);
        return this;
    }

    public boolean isActive() {
        return this.world.getEntityManager().isActive(this.id);
    }

    @Deprecated
    public boolean isEnabled() {
        return this.world.getEntityManager().isEnabled(this.id);
    }

    public Component getComponent(ComponentType type) {
        return this.world.getComponentManager().getComponent(this, type);
    }

    public <T extends Component> T getComponent(Class<T> type) {
        ComponentTypeFactory tf = this.world.getComponentManager().typeFactory;
        return (T)this.getComponent(tf.getTypeFor(type));
    }

    public Bag<Component> getComponents(Bag<Component> fillBag) {
        return this.world.getComponentManager().getComponentsFor(this, fillBag);
    }

    @Deprecated
    public void addToWorld() {
    }

    @Deprecated
    public void changedInWorld() {
    }

    public void deleteFromWorld() {
        this.edit().deleteEntity();
    }

    @Deprecated
    public void enable() {
        this.world.enable(this);
    }

    @Deprecated
    public void disable() {
        this.world.disable(this);
    }

    @Deprecated
    public UUID getUuid() {
        if (!this.world.hasUuidManager()) {
            throw new MundaneWireException(UuidEntityManager.class);
        }
        return this.world.getManager(UuidEntityManager.class).getUuid(this);
    }

    @Deprecated
    public void setUuid(UUID uuid) {
        if (this.world.hasUuidManager()) {
            this.world.getManager(UuidEntityManager.class).setUuid(this, uuid);
        }
    }

    public World getWorld() {
        return this.world;
    }

    public int getCompositionId() {
        return this.world.getEntityManager().getIdentity(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.id == entity.id;
    }

    public boolean equals(Entity o) {
        return o != null && o.id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

