/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.PackedComponent;
import com.artemis.PooledComponent;
import com.artemis.World;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.Constructor;

public class ComponentType {
    private final Class<? extends Component> type;
    private final Taxonomy taxonomy;
    boolean packedHasWorldConstructor = false;
    private final int index;

    ComponentType(Class<? extends Component> type, int index) {
        this.index = index;
        this.type = type;
        if (ClassReflection.isAssignableFrom(PackedComponent.class, type)) {
            this.taxonomy = Taxonomy.PACKED;
            this.packedHasWorldConstructor = ComponentType.hasWorldConstructor(type);
        } else {
            this.taxonomy = ClassReflection.isAssignableFrom(PooledComponent.class, type) ? Taxonomy.POOLED : Taxonomy.BASIC;
        }
    }

    private static boolean hasWorldConstructor(Class<? extends Component> type) {
        Constructor[] constructors = ClassReflection.getConstructors(type);
        for (int i = 0; constructors.length > i; ++i) {
            Class[] types = constructors[i].getParameterTypes();
            if (types.length != 1 || types[0] != World.class) continue;
            return true;
        }
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    protected Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public boolean isPackedComponent() {
        return this.taxonomy == Taxonomy.PACKED;
    }

    public Class<? extends Component> getType() {
        return this.type;
    }

    public String toString() {
        return "ComponentType[" + ClassReflection.getSimpleName(this.type) + "] (" + this.index + ")";
    }

    static enum Taxonomy {
        BASIC,
        POOLED,
        PACKED;

    }
}

