/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.BasicComponentMapper;
import com.artemis.Component;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.PackedComponent;
import com.artemis.PackedComponentMapper;
import com.artemis.World;

public abstract class ComponentMapper<A extends Component> {
    public A get(Entity e) throws ArrayIndexOutOfBoundsException {
        return this.get(e.getId());
    }

    public abstract A get(int var1) throws ArrayIndexOutOfBoundsException;

    public A get(Entity e, boolean forceNewInstance) throws ArrayIndexOutOfBoundsException {
        return this.get(e.getId(), forceNewInstance);
    }

    public abstract A get(int var1, boolean var2) throws ArrayIndexOutOfBoundsException;

    public A getSafe(Entity e) {
        return this.getSafe(e.getId());
    }

    public abstract A getSafe(int var1);

    public A getSafe(Entity e, boolean forceNewInstance) {
        return this.getSafe(e.getId(), forceNewInstance);
    }

    public abstract A getSafe(int var1, boolean var2);

    public boolean has(Entity e) throws ArrayIndexOutOfBoundsException {
        return this.has(e.getId());
    }

    public abstract boolean has(int var1);

    public static <T extends Component> ComponentMapper<T> getFor(Class<T> type, World world) {
        ComponentTypeFactory tf = world.getComponentManager().typeFactory;
        if (tf.getTypeFor(type).isPackedComponent()) {
            return PackedComponentMapper.create(type, world);
        }
        return new BasicComponentMapper<PackedComponent>(type, world);
    }
}

