/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentMapper;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.World;
import com.artemis.utils.Bag;

class BasicComponentMapper<A extends Component>
extends ComponentMapper<A> {
    private final ComponentType type;
    private final Bag<Component> components;

    BasicComponentMapper(Class<A> type, World world) {
        ComponentTypeFactory tf = world.getComponentManager().typeFactory;
        this.type = tf.getTypeFor(type);
        this.components = world.getComponentManager().getComponentsByType(this.type);
    }

    @Override
    public A get(int entityId) throws ArrayIndexOutOfBoundsException {
        return (A)this.components.get(entityId);
    }

    @Override
    public A getSafe(int entityId) {
        if (this.components.isIndexWithinBounds(entityId)) {
            return (A)this.components.get(entityId);
        }
        return null;
    }

    @Override
    public boolean has(int entityId) {
        return this.getSafe(entityId) != null;
    }

    @Override
    public A get(int entityId, boolean forceNewInstance) throws ArrayIndexOutOfBoundsException {
        return this.get(entityId);
    }

    @Override
    public A getSafe(int entityId, boolean forceNewInstance) {
        return this.getSafe(entityId);
    }
}

