/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Aspect;
import com.artemis.EntityObserver;
import com.artemis.EntitySubscription;
import com.artemis.Manager;
import com.artemis.utils.Bag;
import com.artemis.utils.ConverterUtil;
import com.artemis.utils.IntBag;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class AspectSubscriptionManager
extends Manager {
    private final Map<Aspect.Builder, EntitySubscription> subscriptionMap;
    private Bag<EntitySubscription> subscriptions;
    private final IntBag addedIds = new IntBag();
    private final IntBag changedIds = new IntBag();
    private final IntBag deletedIds = new IntBag();
    private final AddedPerformer addedPerformer;
    private final ChangedPerformer changedPerformer;
    private final DeletedPerformer deletedPerformer;
    private final EnabledPerformer enabledPerformer;
    private final DisabledPerformer disabledPerformer;

    protected AspectSubscriptionManager() {
        this.subscriptionMap = new HashMap<Aspect.Builder, EntitySubscription>();
        this.subscriptions = new Bag();
        this.addedPerformer = new AddedPerformer();
        this.changedPerformer = new ChangedPerformer();
        this.deletedPerformer = new DeletedPerformer();
        this.enabledPerformer = new EnabledPerformer();
        this.disabledPerformer = new DisabledPerformer();
    }

    public EntitySubscription get(Aspect.Builder builder) {
        EntitySubscription subscription = this.subscriptionMap.get(builder);
        return subscription != null ? subscription : this.createSubscription(builder);
    }

    private EntitySubscription createSubscription(Aspect.Builder builder) {
        EntitySubscription entitySubscription = new EntitySubscription(this.world, builder);
        this.subscriptionMap.put(builder, entitySubscription);
        this.subscriptions.add(entitySubscription);
        this.world.getEntityManager().synchronize(entitySubscription);
        return entitySubscription;
    }

    void process(BitSet added, BitSet changed, BitSet deleted) {
        this.toEntityIntBags(added, changed, deleted);
        this.check(this.addedIds, this.addedPerformer);
        this.check(this.changedIds, this.changedPerformer);
        this.check(this.deletedIds, this.deletedPerformer);
        Object[] subscribers = this.subscriptions.getData();
        int s = this.subscriptions.size();
        for (int i = 0; s > i; ++i) {
            EntitySubscription subscriber = (EntitySubscription)subscribers[i];
            subscriber.process(this.addedIds, this.changedIds, this.deletedIds);
        }
        this.addedIds.setSize(0);
        this.changedIds.setSize(0);
        this.deletedIds.setSize(0);
    }

    private void toEntityIntBags(BitSet added, BitSet changed, BitSet deleted) {
        ConverterUtil.toIntBag(added, this.addedIds);
        ConverterUtil.toIntBag(changed, this.changedIds);
        ConverterUtil.toIntBag(deleted, this.deletedIds);
        added.clear();
        changed.clear();
        deleted.clear();
    }

    void processComponentIdentity(int id, BitSet componentBits) {
        Object[] subscribers = this.subscriptions.getData();
        int s = this.subscriptions.size();
        for (int i = 0; s > i; ++i) {
            EntitySubscription subscriber = (EntitySubscription)subscribers[i];
            subscriber.processComponentIdentity(id, componentBits);
        }
    }

    private void check(IntBag entityIds, Performer performer) {
        if (entityIds.isEmpty()) {
            return;
        }
        this.notifyManagers(performer, entityIds);
    }

    private void notifyManagers(Performer performer, IntBag entities) {
        Object[] data = this.world.managersBag.getData();
        int s = this.world.managersBag.size();
        for (int i = 0; s > i; ++i) {
            performer.perform((Manager)data[i], entities);
        }
    }

    private static interface Performer {
        public void perform(EntityObserver var1, IntBag var2);
    }

    private static final class AddedPerformer
    implements Performer {
        private AddedPerformer() {
        }

        @Override
        public void perform(EntityObserver observer, IntBag entities) {
            observer.added(entities);
        }
    }

    private static final class ChangedPerformer
    implements Performer {
        private ChangedPerformer() {
        }

        @Override
        public void perform(EntityObserver observer, IntBag entities) {
            observer.changed(entities);
        }
    }

    private static final class DisabledPerformer
    implements Performer {
        private DisabledPerformer() {
        }

        @Override
        public void perform(EntityObserver observer, IntBag entities) {
            int[] ids = entities.getData();
            int s = entities.size();
            for (int i = 0; s > i; ++i) {
                observer.disabled(ids[i]);
            }
        }
    }

    private static final class EnabledPerformer
    implements Performer {
        private EnabledPerformer() {
        }

        @Override
        public void perform(EntityObserver observer, IntBag entities) {
            int[] ids = entities.getData();
            int s = entities.size();
            for (int i = 0; s > i; ++i) {
                observer.enabled(ids[i]);
            }
        }
    }

    private static final class DeletedPerformer
    implements Performer {
        private DeletedPerformer() {
        }

        @Override
        public void perform(EntityObserver observer, IntBag entities) {
            observer.deleted(entities);
        }
    }
}

