/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Component;
import com.artemis.ComponentTypeFactory;
import com.artemis.Entity;
import com.artemis.World;
import com.artemis.utils.Bag;
import java.util.BitSet;
import java.util.Collection;

public class Aspect {
    private BitSet allSet = new BitSet();
    private BitSet exclusionSet = new BitSet();
    private BitSet oneSet = new BitSet();

    private Aspect() {
    }

    public BitSet getAllSet() {
        return this.allSet;
    }

    public BitSet getExclusionSet() {
        return this.exclusionSet;
    }

    public BitSet getOneSet() {
        return this.oneSet;
    }

    public boolean isInterested(Entity e) {
        return this.isInterested(e.getComponentBits());
    }

    public boolean isInterested(BitSet componentBits) {
        if (!this.allSet.isEmpty()) {
            int i = this.allSet.nextSetBit(0);
            while (i >= 0) {
                if (!componentBits.get(i)) {
                    return false;
                }
                i = this.allSet.nextSetBit(i + 1);
            }
        }
        if (!this.exclusionSet.isEmpty() && this.exclusionSet.intersects(componentBits)) {
            return false;
        }
        return this.oneSet.isEmpty() || this.oneSet.intersects(componentBits);
    }

    @SafeVarargs
    public static final Builder all(Class<? extends Component> ... types) {
        return new Builder().all(types);
    }

    public static Builder all(Collection<Class<? extends Component>> types) {
        return new Builder().all(types);
    }

    @SafeVarargs
    public static final Builder exclude(Class<? extends Component> ... types) {
        return new Builder().exclude(types);
    }

    public static Builder exclude(Collection<Class<? extends Component>> types) {
        return new Builder().exclude(types);
    }

    @SafeVarargs
    public static final Builder one(Class<? extends Component> ... types) {
        return new Builder().one(types);
    }

    public static Builder one(Collection<Class<? extends Component>> types) {
        return new Builder().one(types);
    }

    @Deprecated
    @SafeVarargs
    public static final Builder getAspectForAll(Class<? extends Component> ... types) {
        return Aspect.all(types);
    }

    @Deprecated
    @SafeVarargs
    public static final Builder getAspectForOne(Class<? extends Component> ... types) {
        return Aspect.one(types);
    }

    @Deprecated
    public static Builder getEmpty() {
        return new Builder();
    }

    public static class Builder {
        private final Bag<Class<? extends Component>> allTypes = new Bag();
        private final Bag<Class<? extends Component>> exclusionTypes = new Bag();
        private final Bag<Class<? extends Component>> oneTypes = new Bag();

        private Builder() {
        }

        public Builder all(Class<? extends Component> ... types) {
            for (Class<? extends Component> t : types) {
                this.allTypes.add(t);
            }
            return this;
        }

        public Builder all(Collection<Class<? extends Component>> types) {
            for (Class<? extends Component> t : types) {
                this.allTypes.add(t);
            }
            return this;
        }

        public Builder one(Class<? extends Component> ... types) {
            for (Class<? extends Component> t : types) {
                this.oneTypes.add(t);
            }
            return this;
        }

        public Builder one(Collection<Class<? extends Component>> types) {
            for (Class<? extends Component> t : types) {
                this.oneTypes.add(t);
            }
            return this;
        }

        public Builder exclude(Class<? extends Component> ... types) {
            for (Class<? extends Component> t : types) {
                this.exclusionTypes.add(t);
            }
            return this;
        }

        public Builder exclude(Collection<Class<? extends Component>> types) {
            for (Class<? extends Component> t : types) {
                this.exclusionTypes.add(t);
            }
            return this;
        }

        public Aspect build(World world) {
            ComponentTypeFactory tf = world.getComponentManager().typeFactory;
            Aspect aspect = new Aspect();
            Builder.associate(tf, this.allTypes, aspect.allSet);
            Builder.associate(tf, this.exclusionTypes, aspect.exclusionSet);
            Builder.associate(tf, this.oneTypes, aspect.oneSet);
            return aspect;
        }

        private static void associate(ComponentTypeFactory tf, Bag<Class<? extends Component>> types, BitSet componentBits) {
            for (Class<? extends Component> t : types) {
                componentBits.set(tf.getIndexFor(t));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (!this.allTypes.equals(builder.allTypes)) {
                return false;
            }
            if (!this.exclusionTypes.equals(builder.exclusionTypes)) {
                return false;
            }
            return this.oneTypes.equals(builder.oneTypes);
        }

        public int hashCode() {
            int result = this.allTypes.hashCode();
            result = 31 * result + this.exclusionTypes.hashCode();
            result = 31 * result + this.oneTypes.hashCode();
            return result;
        }
    }
}

