/*
 * Decompiled with CFR 0.152.
 */
package com.artemis;

import com.artemis.Archetype;
import com.artemis.Component;
import com.artemis.ComponentManager;
import com.artemis.ComponentType;
import com.artemis.ComponentTypeFactory;
import com.artemis.EntityManager;
import com.artemis.MundaneWireException;
import com.artemis.World;
import com.artemis.utils.Bag;
import java.util.BitSet;

public class ArchetypeBuilder {
    private final Bag<Class<? extends Component>> classes = new Bag();

    public ArchetypeBuilder(Archetype parent) {
        if (parent == null) {
            return;
        }
        for (int i = 0; parent.types.length > i; ++i) {
            this.classes.add(parent.types[i].getType());
        }
    }

    public ArchetypeBuilder() {
        this(null);
    }

    public ArchetypeBuilder add(Class<? extends Component> type) {
        if (!this.classes.contains(type)) {
            this.classes.add(type);
        }
        return this;
    }

    public ArchetypeBuilder add(Class<? extends Component> ... types) {
        for (int i = 0; types.length > i; ++i) {
            Class<? extends Component> type = types[i];
            if (this.classes.contains(type)) continue;
            this.classes.add(type);
        }
        return this;
    }

    public ArchetypeBuilder remove(Class<? extends Component> type) {
        this.classes.remove(type);
        return this;
    }

    public ArchetypeBuilder remove(Class<? extends Component> ... types) {
        for (int i = 0; types.length > i; ++i) {
            this.classes.remove(types[i]);
        }
        return this;
    }

    public Archetype build(World world) {
        ComponentType[] types = this.resolveTypes(world);
        EntityManager em = world.getEntityManager();
        return new Archetype(types, em.compositionIdentity(ArchetypeBuilder.bitset(types)));
    }

    private static BitSet bitset(ComponentType[] types) {
        BitSet bs = new BitSet();
        for (int i = 0; types.length > i; ++i) {
            bs.set(types[i].getIndex());
        }
        return bs;
    }

    private ComponentType[] resolveTypes(World world) {
        ComponentManager cm = world.getComponentManager();
        if (cm == null) {
            throw new MundaneWireException("World#initialize() has not been called.");
        }
        ComponentTypeFactory tf = cm.typeFactory;
        ComponentType[] types = new ComponentType[this.classes.size()];
        int s = this.classes.size();
        for (int i = 0; s > i; ++i) {
            types[i] = tf.getTypeFor(this.classes.get(i));
        }
        return types;
    }
}

