/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.JsonWriter;
import net.jsign.jca.OracleCloudCredentials;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class OracleCloudSigningService
implements SigningService {
    private final Function<String, Certificate[]> certificateStore;
    private final OracleCloudCredentials credentials;
    private final Map<String, String> algorithmMapping = new HashMap<String, String>();

    public OracleCloudSigningService(OracleCloudCredentials credentials, Function<String, Certificate[]> certificateStore) {
        this.algorithmMapping.put("SHA256withRSA", "SHA_256_RSA_PKCS1_V1_5");
        this.algorithmMapping.put("SHA384withRSA", "SHA_384_RSA_PKCS1_V1_5");
        this.algorithmMapping.put("SHA512withRSA", "SHA_512_RSA_PKCS1_V1_5");
        this.algorithmMapping.put("SHA256withECDSA", "ECDSA_SHA_256");
        this.algorithmMapping.put("SHA384withECDSA", "ECDSA_SHA_384");
        this.algorithmMapping.put("SHA512withECDSA", "ECDSA_SHA_512");
        this.algorithmMapping.put("SHA256withRSA/PSS", "SHA_256_RSA_PKCS_PSS");
        this.algorithmMapping.put("SHA384withRSA/PSS", "SHA_394_RSA_PKCS_PSS");
        this.algorithmMapping.put("SHA512withRSA/PSS", "SHA_512_RSA_PKCS_PSS");
        this.credentials = credentials;
        this.certificateStore = certificateStore;
    }

    @Override
    public String getName() {
        return "OracleCloud";
    }

    String getVaultEndpoint() {
        return "https://kms." + this.credentials.getRegion() + ".oraclecloud.com";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Object[] vaults;
            RESTClient kmsClient = new RESTClient(this.getVaultEndpoint()).authentication(this::sign).errorHandler(this::error);
            Map<String, ?> result = kmsClient.get("/20180608/vaults?compartmentId=" + this.credentials.getTenancy());
            for (Object v : vaults = (Object[])result.get("result")) {
                Object[] keys;
                Map vault = (Map)v;
                if (!"ACTIVE".equals(vault.get("lifecycleState"))) continue;
                String endpoint = (String)vault.get("managementEndpoint");
                RESTClient managementClient = new RESTClient(endpoint).authentication(this::sign).errorHandler(this::error);
                result = managementClient.get("/20180608/keys?compartmentId=" + this.credentials.getTenancy());
                for (Object k : keys = (Object[])result.get("result")) {
                    Map key = (Map)k;
                    if (!"ENABLED".equals(key.get("lifecycleState")) || "EXTERNAL".equals(key.get("protectionMode"))) continue;
                    aliases.add((String)key.get("id"));
                }
            }
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        return aliases;
    }

    @Override
    public Certificate[] getCertificateChain(String alias) {
        return this.certificateStore.apply(alias);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        Certificate[] chain = this.getCertificateChain(alias);
        String algorithm = chain[0].getPublicKey().getAlgorithm();
        return new SigningServicePrivateKey(alias, algorithm, this);
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        String alg = this.algorithmMapping.get(algorithm);
        if (alg == null) {
            throw new InvalidAlgorithmParameterException("Unsupported signing algorithm: " + algorithm);
        }
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("keyId", privateKey.getId());
        request.put("messageType", "RAW");
        request.put("message", Base64.getEncoder().encodeToString(data));
        request.put("signingAlgorithm", alg);
        try {
            RESTClient client = new RESTClient(this.getKeyEndpoint(privateKey.getId())).authentication(this::sign).errorHandler(this::error);
            Map<String, ?> response = client.post("/20180608/sign", JsonWriter.format(request));
            String signature = (String)response.get("signature");
            return Base64.getDecoder().decode(signature);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    String getKeyEndpoint(String keyId) {
        Pattern pattern = Pattern.compile("ocid1\\.key\\.oc1\\.([^.]*)\\.([^.]*)\\..*");
        Matcher matcher = pattern.matcher(keyId);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid key id: " + keyId);
        }
        String region = matcher.group(1);
        String vaultId = matcher.group(2);
        String hostname = vaultId + "-crypto.kms." + region + ".oci.oraclecloud.com";
        if (this.isUnknownHost(hostname)) {
            hostname = vaultId + "-crypto.kms." + region + ".oraclecloud.com";
        }
        return "https://" + hostname;
    }

    boolean isUnknownHost(String hostname) {
        try {
            InetAddress.getByName(hostname);
            return false;
        }
        catch (UnknownHostException uhe) {
            return true;
        }
    }

    private void sign(HttpURLConnection conn, byte[] data) {
        StringBuilder signedHeaders = new StringBuilder();
        StringBuilder stringToSign = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = dateFormat.format(new Date());
        conn.setRequestProperty("Date", date);
        this.addSignedHeader(signedHeaders, stringToSign, "date", date);
        String query = conn.getURL().getPath() + (conn.getURL().getQuery() != null ? "?" + conn.getURL().getQuery() : "");
        this.addSignedHeader(signedHeaders, stringToSign, "(request-target)", conn.getRequestMethod().toLowerCase() + " " + query);
        this.addSignedHeader(signedHeaders, stringToSign, "host", conn.getURL().getHost());
        if (data != null) {
            int contentLength = data.length;
            conn.setRequestProperty("Content-Length", String.valueOf(contentLength));
            this.addSignedHeader(signedHeaders, stringToSign, "content-length", String.valueOf(contentLength));
            conn.setRequestProperty("Content-Type", "application/json");
            this.addSignedHeader(signedHeaders, stringToSign, "content-type", "application/json");
            String digest = Base64.getEncoder().encodeToString(DigestAlgorithm.SHA256.getMessageDigest().digest(data));
            conn.setRequestProperty("x-content-sha256", digest);
            this.addSignedHeader(signedHeaders, stringToSign, "x-content-sha256", digest);
        }
        String signature = Base64.getEncoder().encodeToString(this.rsa256sign(this.credentials.getPrivateKey(), stringToSign.toString().trim()));
        String authorization = String.format("Signature headers=\"%s\",keyId=\"%s\",algorithm=\"rsa-sha256\",signature=\"%s\",version=\"1\"", signedHeaders.toString().trim(), this.credentials.getKeyId(), signature);
        conn.setRequestProperty("Authorization", authorization);
    }

    private void addSignedHeader(StringBuilder signedHeaders, StringBuilder stringToSign, String key, String value) {
        signedHeaders.append(key).append(" ");
        stringToSign.append(key).append(": ").append(value).append("\n");
    }

    private byte[] rsa256sign(PrivateKey privateKey, String message) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private String error(Map<String, ?> response) {
        return response.get("code") + ": " + response.get("message");
    }
}

