/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jsign.zip.ExtraField;

class Zip64ExtendedInfoExtraField
extends ExtraField {
    public long uncompressedSize;
    public long compressedSize;
    public long localHeaderOffset;
    public int diskNumberStart;

    public Zip64ExtendedInfoExtraField(boolean uncompressedSize, boolean compressedSize, boolean localHeaderOffset, boolean diskNumberStart) {
        this.id = 1;
        this.uncompressedSize = uncompressedSize ? 0L : -1L;
        this.compressedSize = compressedSize ? 0L : -1L;
        this.localHeaderOffset = localHeaderOffset ? 0L : -1L;
        this.diskNumberStart = diskNumberStart ? 0 : -1;
    }

    public Zip64ExtendedInfoExtraField(long uncompressedSize, long compressedSize, long localHeaderOffset, int diskNumberStart) {
        this.id = 1;
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
        this.localHeaderOffset = localHeaderOffset;
        this.diskNumberStart = diskNumberStart;
        this.update();
    }

    @Override
    protected void parse() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN);
        try {
            if (this.uncompressedSize != -1L) {
                this.uncompressedSize = buffer.getLong();
            }
            if (this.compressedSize != -1L) {
                this.compressedSize = buffer.getLong();
            }
            if (this.localHeaderOffset != -1L) {
                this.localHeaderOffset = buffer.getLong();
            }
            if (this.diskNumberStart != -1) {
                this.diskNumberStart = buffer.getInt();
            }
        }
        catch (BufferUnderflowException e) {
            throw new IOException("Invalid ZIP64 extended information extra field", e);
        }
    }

    @Override
    public void update() {
        int size = 0;
        if (this.uncompressedSize != -1L) {
            size += 8;
        }
        if (this.compressedSize != -1L) {
            size += 8;
        }
        if (this.localHeaderOffset != -1L) {
            size += 8;
        }
        if (this.diskNumberStart != -1) {
            size += 4;
        }
        this.data = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(this.data).order(ByteOrder.LITTLE_ENDIAN);
        if (this.uncompressedSize != -1L) {
            buffer.putLong(this.uncompressedSize);
        }
        if (this.compressedSize != -1L) {
            buffer.putLong(this.compressedSize);
        }
        if (this.localHeaderOffset != -1L) {
            buffer.putLong(this.localHeaderOffset);
        }
        if (this.diskNumberStart != -1) {
            buffer.putInt(this.diskNumberStart);
        }
    }
}

