/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.pe;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.SignatureUtils;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcPeImageData;
import net.jsign.pe.CertificateTableEntry;
import net.jsign.pe.DataDirectory;
import net.jsign.pe.DataDirectoryType;
import net.jsign.pe.PEFormat;
import net.jsign.pe.PEImageChecksum;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSSignedData;

public class PEFile
implements Signable {
    private final long peHeaderOffset;
    final SeekableByteChannel channel;
    private final ByteBuffer valueBuffer = ByteBuffer.allocate(8);

    public static boolean isPEFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        try {
            PEFile peFile = new PEFile(file);
            peFile.close();
            return true;
        }
        catch (IOException e) {
            if (e.getMessage().contains("DOS header signature not found") || e.getMessage().contains("PE signature not found")) {
                return false;
            }
            throw e;
        }
    }

    public PEFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
    }

    public PEFile(SeekableByteChannel channel) throws IOException {
        this.valueBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.channel = channel;
        try {
            if (channel.size() >= 0x100000000L) {
                throw new IOException("Invalid PE file: the size exceeds 4GB");
            }
            this.read(0L, 0, 2);
            if (this.valueBuffer.get() != 77 || this.valueBuffer.get() != 90) {
                throw new IOException("DOS header signature not found");
            }
            this.read(60L, 0, 4);
            this.peHeaderOffset = (long)this.valueBuffer.getInt() & 0xFFFFFFFFL;
            this.read(this.peHeaderOffset, 0, 4);
            if (this.valueBuffer.get() != 80 || this.valueBuffer.get() != 69 || this.valueBuffer.get() != 0 || this.valueBuffer.get() != 0) {
                throw new IOException("PE signature not found as expected at offset 0x" + Long.toHexString(this.peHeaderOffset));
            }
        }
        catch (IOException e) {
            channel.close();
            throw e;
        }
    }

    @Override
    public void save() {
    }

    @Override
    public synchronized void close() throws IOException {
        this.channel.close();
    }

    synchronized int read(byte[] buffer, long base, int offset) throws IOException {
        this.channel.position(base + (long)offset);
        return this.channel.read(ByteBuffer.wrap(buffer));
    }

    private void read(long base, int offset, int length) throws IOException {
        this.valueBuffer.limit(length);
        this.valueBuffer.clear();
        this.channel.position(base + (long)offset);
        this.channel.read(this.valueBuffer);
        this.valueBuffer.rewind();
    }

    synchronized int readWord(long base, int offset) throws IOException {
        this.read(base, offset, 2);
        return this.valueBuffer.getShort() & 0xFFFF;
    }

    synchronized long readDWord(long base, int offset) throws IOException {
        this.read(base, offset, 4);
        return (long)this.valueBuffer.getInt() & 0xFFFFFFFFL;
    }

    synchronized void write(long base, byte[] data) throws IOException {
        this.write(base, ByteBuffer.wrap(data));
    }

    synchronized void write(long base, ByteBuffer data) throws IOException {
        this.channel.position(base);
        while (data.hasRemaining()) {
            this.channel.write(data);
        }
    }

    PEFormat getFormat() throws IOException {
        return PEFormat.valueOf(this.readWord(this.peHeaderOffset, 24));
    }

    long getCheckSum() throws IOException {
        return this.readDWord(this.peHeaderOffset, 88);
    }

    synchronized long computeChecksum() throws IOException {
        int len;
        PEImageChecksum checksum = new PEImageChecksum(this.peHeaderOffset + 88L);
        ByteBuffer b = ByteBuffer.allocate(65536);
        this.channel.position(0L);
        while ((len = this.channel.read(b)) > 0) {
            b.flip();
            checksum.update(b.array(), 0, len);
        }
        return checksum.getValue();
    }

    synchronized void updateChecksum() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt((int)this.computeChecksum());
        buffer.flip();
        this.write(this.peHeaderOffset + 88L, buffer);
    }

    int getNumberOfRvaAndSizes() throws IOException {
        return (int)this.readDWord(this.peHeaderOffset, PEFormat.PE32.equals((Object)this.getFormat()) ? 116 : 132);
    }

    int getDataDirectoryOffset() throws IOException {
        return (int)this.peHeaderOffset + (PEFormat.PE32.equals((Object)this.getFormat()) ? 120 : 136);
    }

    DataDirectory getDataDirectory(DataDirectoryType type) throws IOException {
        if (type.ordinal() >= this.getNumberOfRvaAndSizes()) {
            return null;
        }
        return new DataDirectory(this, type.ordinal());
    }

    synchronized void writeCertificateTable(byte[] data) throws IOException {
        DataDirectory directory = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
        if (directory == null) {
            throw new IOException("No space allocated in the data directories index for the certificate table");
        }
        if (!directory.exists()) {
            long offset = this.channel.size() + (8L - this.channel.size() % 8L) % 8L;
            this.write(offset, data);
            directory.write(offset, data.length);
        } else if (directory.isTrailing()) {
            this.write(directory.getVirtualAddress(), data);
            this.channel.truncate(directory.getVirtualAddress() + (long)data.length);
            directory.write(directory.getVirtualAddress(), data.length);
        } else {
            throw new IOException("The certificate table isn't at the end of the file");
        }
        this.updateChecksum();
    }

    @Override
    public synchronized List<CMSSignedData> getSignatures() throws IOException {
        ArrayList<CMSSignedData> signatures = new ArrayList<CMSSignedData>();
        for (CertificateTableEntry certificate : this.getCertificateTable()) {
            if (!certificate.isSupported()) continue;
            signatures.addAll(SignatureUtils.getSignatures(certificate.getContent()));
        }
        return signatures;
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (signature != null) {
            CertificateTableEntry entry = new CertificateTableEntry(signature);
            this.writeCertificateTable(entry.toBytes());
        } else if (this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE).exists()) {
            DataDirectory certificateTable = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
            this.channel.truncate(certificateTable.getVirtualAddress());
            certificateTable.write(0L, 0);
        }
    }

    private synchronized List<CertificateTableEntry> getCertificateTable() throws IOException {
        ArrayList<CertificateTableEntry> entries = new ArrayList<CertificateTableEntry>();
        DataDirectory certificateTable = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
        if (certificateTable != null && certificateTable.exists()) {
            long position = certificateTable.getVirtualAddress();
            try {
                if (position < this.channel.size()) {
                    entries.add(new CertificateTableEntry(this, position));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entries;
    }

    @Override
    public synchronized byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        MessageDigest digest = digestAlgorithm.getMessageDigest();
        long checksumLocation = this.peHeaderOffset + 88L;
        DataDirectory certificateTable = this.getDataDirectory(DataDirectoryType.CERTIFICATE_TABLE);
        ChannelUtils.updateDigest(this.channel, digest, 0L, checksumLocation);
        long position = checksumLocation + 4L;
        int certificateTableOffset = this.getDataDirectoryOffset() + 8 * DataDirectoryType.CERTIFICATE_TABLE.ordinal();
        ChannelUtils.updateDigest(this.channel, digest, position, certificateTableOffset);
        position = certificateTableOffset + 8;
        if (certificateTable != null && certificateTable.exists()) {
            certificateTable.check();
            ChannelUtils.updateDigest(this.channel, digest, position, certificateTable.getVirtualAddress());
            position = certificateTable.getVirtualAddress() + (long)certificateTable.getSize();
        }
        ChannelUtils.updateDigest(this.channel, digest, position, this.channel.size());
        if (certificateTable == null || !certificateTable.exists()) {
            int paddingLength = (int)(8L - this.channel.size() % 8L) % 8;
            digest.update(new byte[paddingLength]);
        }
        return digest.digest();
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_PE_IMAGE_DATA_OBJID, new SpcPeImageData());
        return new SpcIndirectDataContent(data, digestInfo);
    }
}

