/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.stateful.Action;
import net.jqwik.engine.properties.stateful.ActionGenerator;

class ListActionGenerator<T>
implements ActionGenerator<T> {
    private final Iterator<Action<T>> iterator;
    private List<Shrinkable<Action<T>>> generated = new ArrayList<Shrinkable<Action<T>>>();

    ListActionGenerator(List<Action<T>> listOfActions) {
        this.iterator = listOfActions.iterator();
    }

    @Override
    public Action<T> next(T model) {
        while (this.iterator.hasNext()) {
            Action<T> next = this.iterator.next();
            if (!next.precondition(model)) continue;
            this.generated.add(Shrinkable.unshrinkable(next));
            return next;
        }
        throw new NoSuchElementException("No more actions available");
    }

    @Override
    public List<Shrinkable<Action<T>>> generated() {
        return this.generated;
    }
}

