/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.engine.properties.shrinking.ShrinkableContainer;

public class ShrinkableSet<E>
extends ShrinkableContainer<Set<E>, E> {
    private final int minSize;

    public ShrinkableSet(Set<Shrinkable<E>> elements, int minSize) {
        this(new ArrayList<Shrinkable<E>>(elements), minSize);
    }

    private ShrinkableSet(List<Shrinkable<E>> elements, int minSize) {
        super(elements, minSize);
        this.minSize = minSize;
    }

    @Override
    public ShrinkingSequence<Set<E>> shrink(Falsifier<Set<E>> falsifier) {
        return super.shrink(falsifier.withFilter(set -> set.size() >= this.minSize));
    }

    @Override
    Collector<E, ?, Set<E>> containerCollector() {
        return Collectors.toSet();
    }

    @Override
    Shrinkable<Set<E>> createShrinkable(List<Shrinkable<E>> shrunkElements) {
        return new ShrinkableSet<E>(shrunkElements, this.minSize);
    }
}

