/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingSequence;

public class DeepSearchShrinkingSequence<T>
implements ShrinkingSequence<T> {
    private final Function<Shrinkable<T>, Set<Shrinkable<T>>> candidatesFor;
    private final Falsifier<T> falsifier;
    private FalsificationResult<T> currentBest;
    private FalsificationResult<T> searchBase;
    private boolean lastStepSuccessful = true;

    public DeepSearchShrinkingSequence(Shrinkable<T> startingShrinkable, Function<Shrinkable<T>, Set<Shrinkable<T>>> candidatesFor, Falsifier<T> falsifier) {
        this.currentBest = FalsificationResult.falsified(startingShrinkable);
        this.searchBase = this.currentBest;
        this.candidatesFor = candidatesFor;
        this.falsifier = falsifier;
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
        if (!this.lastStepSuccessful) {
            return false;
        }
        this.lastStepSuccessful = false;
        Set<Shrinkable<T>> candidates = this.getShrinkableCandidates();
        List nextBase = candidates.stream().sorted().map(this::falsify).filter(result -> result.status() != FalsificationResult.Status.VERIFIED).collect(Collectors.toList());
        nextBase.stream().filter(result -> result.status() == FalsificationResult.Status.FALSIFIED).findFirst().ifPresent(result -> {
            count.run();
            this.lastStepSuccessful = true;
            this.currentBest = result;
            falsifiedReporter.accept(this.currentBest);
            this.searchBase = this.currentBest;
        });
        nextBase.stream().filter(result -> result.status() == FalsificationResult.Status.FILTERED_OUT).filter(result -> result.shrinkable().isSmallerThan(this.currentBest.shrinkable())).filter(result -> result.shrinkable().isSmallerThan(this.searchBase.shrinkable())).findFirst().ifPresent(result -> {
            count.run();
            this.lastStepSuccessful = true;
            this.searchBase = result;
        });
        return this.lastStepSuccessful;
    }

    private Set<Shrinkable<T>> getShrinkableCandidates() {
        HashSet<Shrinkable<T>> candidates = new HashSet<Shrinkable<T>>((Collection)this.candidatesFor.apply(this.searchBase.shrinkable()));
        if (this.searchBase != this.currentBest) {
            candidates.addAll((Collection)this.candidatesFor.apply(this.currentBest.shrinkable()));
        }
        return candidates;
    }

    private FalsificationResult<T> falsify(Shrinkable<T> candidate) {
        return this.falsifier.falsify(candidate);
    }

    public FalsificationResult<T> current() {
        return this.currentBest;
    }

    public void init(FalsificationResult<T> initialCurrent) {
        this.currentBest = FalsificationResult.falsified((Shrinkable)this.currentBest.shrinkable(), (Throwable)initialCurrent.throwable().orElse(null));
    }
}

