/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Falsifier;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.arbitraries.randomized.AbstractFunctionGenerator;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class FunctionGenerator<F, R>
extends AbstractFunctionGenerator<F, R> {
    private final AtomicReference<Shrinkable<R>> lastResult = new AtomicReference();

    public FunctionGenerator(Class<F> functionalType, RandomGenerator<R> resultGenerator, List<Tuple.Tuple2<Predicate<List>, Function<List, R>>> conditions) {
        super(functionalType, resultGenerator, conditions);
    }

    public Shrinkable<F> next(Random random) {
        return new ShrinkableFunction(this.createFunction(random));
    }

    private F createFunction(Random random) {
        long baseSeed = random.nextLong();
        InvocationHandler handler = (proxy, method, args) -> {
            if (JqwikReflectionSupport.isToStringMethod(method)) {
                return String.format("Function<%s>(baseSeed: %s)", this.functionalType.getSimpleName(), baseSeed);
            }
            return this.conditionalResult(args).orElseGet(() -> {
                Random randomForArgs = new Random(this.seedForArgs(baseSeed, args));
                Shrinkable shrinkableResult = this.resultGenerator.next(randomForArgs);
                this.storeLastResult(shrinkableResult);
                return new Object[]{shrinkableResult.value()};
            })[0];
        };
        return this.createFunctionProxy(handler);
    }

    private void storeLastResult(Shrinkable<R> result) {
        this.lastResult.set(result);
    }

    private long seedForArgs(long baseSeed, Object[] args) {
        long seed = baseSeed;
        if (args != null) {
            for (Object arg : args) {
                seed = Long.rotateRight(seed, 16);
                if (arg == null) continue;
                seed ^= (long)arg.hashCode();
            }
        }
        return seed;
    }

    private class ShrinkableFunction
    implements Shrinkable<F> {
        private final F value;

        private ShrinkableFunction(F function) {
            this.value = function;
        }

        public F value() {
            return this.value;
        }

        public ShrinkingSequence<F> shrink(Falsifier<F> falsifier) {
            if (FunctionGenerator.this.lastResult.get() == null) {
                return ShrinkingSequence.dontShrink((Shrinkable)this);
            }
            Shrinkable constantFunction = FunctionGenerator.this.createConstantFunction((Shrinkable)FunctionGenerator.this.lastResult.get());
            return ShrinkingSequence.startWith(constantFunction, falsifier);
        }

        public ShrinkingDistance distance() {
            return ShrinkingDistance.MAX;
        }
    }
}

