/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.FunctionArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.randomized.ConstantFunctionGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.FunctionGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultFunctionArbitrary<F, R>
extends AbstractArbitraryBase
implements FunctionArbitrary<F, R> {
    private final Class<F> functionalType;
    private final Arbitrary<R> resultArbitrary;
    private final List<Tuple.Tuple2<Predicate<List>, Function<List, R>>> conditions = new ArrayList<Tuple.Tuple2<Predicate<List>, Function<List, R>>>();

    public DefaultFunctionArbitrary(Class<F> functionalType, Arbitrary<R> resultArbitrary) {
        this.functionalType = functionalType;
        this.resultArbitrary = resultArbitrary;
    }

    public RandomGenerator<F> generator(int genSize) {
        return RandomGenerators.oneOf(this.createGenerators(genSize));
    }

    private List<RandomGenerator<F>> createGenerators(int genSize) {
        ConstantFunctionGenerator<F, R> constantFunctionGenerator = new ConstantFunctionGenerator<F, R>(this.functionalType, this.resultArbitrary.generator(genSize), this.conditions);
        FunctionGenerator<F, R> functionGenerator = new FunctionGenerator<F, R>(this.functionalType, this.resultArbitrary.generator(genSize), this.conditions);
        return Arrays.asList(constantFunctionGenerator, functionGenerator, functionGenerator, functionGenerator, functionGenerator);
    }

    public <F_> FunctionArbitrary<F_, R> when(Predicate<List> parameterCondition, Function<List, R> answer) {
        DefaultFunctionArbitrary clone = (DefaultFunctionArbitrary)this.typedClone();
        clone.conditions.addAll(this.conditions);
        clone.addCondition(Tuple.of(parameterCondition, answer));
        return clone;
    }

    private void addCondition(Tuple.Tuple2<Predicate<List>, Function<List, R>> condition) {
        this.conditions.add(condition);
    }
}

