/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.CharacterRange;

public class DefaultCharacterArbitrary
extends AbstractArbitraryBase
implements CharacterArbitrary {
    static final char[] WHITESPACE_CHARS;
    static final int MAX_ASCII_CODEPOINT = 127;
    private List<Arbitrary<Character>> parts = new ArrayList<Arbitrary<Character>>();

    static boolean isNoncharacter(int codepoint) {
        if (codepoint >= 64976 && codepoint <= 65007) {
            return true;
        }
        if (codepoint >= 55296 && codepoint <= 57343) {
            return true;
        }
        return codepoint == 65534 || codepoint == 65535;
    }

    static boolean isPrivateUseCharacter(int codepoint) {
        return codepoint >= 57344 && codepoint <= 63743;
    }

    public RandomGenerator<Character> generator(int genSize) {
        return this.arbitrary().generator(genSize);
    }

    private Arbitrary<Character> arbitrary() {
        if (this.parts.isEmpty()) {
            return this.defaultArbitrary();
        }
        if (this.parts.size() == 1) {
            return this.parts.get(0);
        }
        return Arbitraries.oneOf(this.parts);
    }

    private Arbitrary<Character> defaultArbitrary() {
        return this.rangeArbitrary('\u0000', '\uffff').filter(c -> !DefaultCharacterArbitrary.isNoncharacter(c.charValue()) && !DefaultCharacterArbitrary.isPrivateUseCharacter(c.charValue()));
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustive(long maxNumberOfSamples) {
        return this.arbitrary().exhaustive(maxNumberOfSamples);
    }

    public CharacterArbitrary range(char min, char max) {
        return this.cloneWith(this.rangeArbitrary(min, max));
    }

    public CharacterArbitrary with(char ... allowedChars) {
        return this.cloneWith(this.charsArbitrary(allowedChars));
    }

    public CharacterArbitrary with(CharSequence allowedChars) {
        return this.cloneWith(this.charsArbitrary(allowedChars.toString().toCharArray()));
    }

    private Arbitrary<Character> charsArbitrary(char[] allowedChars) {
        return Arbitraries.of((char[])allowedChars);
    }

    public CharacterArbitrary all() {
        return new DefaultCharacterArbitrary();
    }

    public CharacterArbitrary ascii() {
        return this.range('\u0000', '\u007f');
    }

    public CharacterArbitrary digit() {
        return this.range('0', '9');
    }

    public CharacterArbitrary whitespace() {
        return this.with(WHITESPACE_CHARS);
    }

    private CharacterArbitrary cloneWith(Arbitrary<Character> part) {
        DefaultCharacterArbitrary clone = (DefaultCharacterArbitrary)super.typedClone();
        clone.parts = new ArrayList<Arbitrary<Character>>(this.parts);
        clone.parts.add(part);
        return clone;
    }

    private Arbitrary<Character> rangeArbitrary(char min, char max) {
        return new CharacterRange(min, max);
    }

    static {
        StringBuilder whitespace = IntStream.range(0, 65536).filter(Character::isWhitespace).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append);
        int whitespaceLength = whitespace.length();
        char[] charArray = new char[whitespaceLength];
        whitespace.getChars(0, whitespaceLength, charArray, 0);
        WHITESPACE_CHARS = charArray;
    }
}

