/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.List;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.execution.lifecycle.TryLifecycleExecutor;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.opentest4j.TestAbortedException;

public class AroundTryLifecycle
implements TryLifecycleExecutor {
    private final TryExecutor tryExecutor;
    private final AroundTryHook aroundTry;

    public AroundTryLifecycle(TryExecutor tryExecutor, AroundTryHook aroundTry) {
        this.tryExecutor = tryExecutor;
        this.aroundTry = aroundTry;
    }

    @Override
    public TryExecutionResult execute(TryLifecycleContext tryLifecycleContext, List<Object> parameters) {
        try {
            return this.aroundTry.aroundTry(tryLifecycleContext, this.tryExecutor, parameters);
        }
        catch (TestAbortedException exception) {
            return TryExecutionResult.invalid();
        }
        catch (AssertionError | Exception e) {
            return TryExecutionResult.falsified((Throwable)e);
        }
        catch (Throwable throwable) {
            return (TryExecutionResult)JqwikExceptionSupport.throwAsUncheckedException(throwable);
        }
    }
}

