/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.engine.execution.DefaultParameterInjectionContext;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;

class ParameterSupplierResolver {
    private final Map<Parameter, Optional<ResolveParameterHook.ParameterSupplier>> resolvedSuppliers = new HashMap<Parameter, Optional<ResolveParameterHook.ParameterSupplier>>();
    private final ResolveParameterHook resolveParameterHook;
    private final LifecycleContext lifecycleContext;

    ParameterSupplierResolver(ResolveParameterHook resolveParameterHook, LifecycleContext lifecycleContext) {
        this.resolveParameterHook = resolveParameterHook;
        this.lifecycleContext = lifecycleContext;
    }

    Optional<ResolveParameterHook.ParameterSupplier> resolveParameter(Executable executable, int index, Class<?> containerClass) {
        Parameter[] parameters = executable.getParameters();
        if (index >= 0 && index < parameters.length) {
            Parameter parameter = parameters[index];
            MethodParameter methodParameter = JqwikReflectionSupport.getMethodParameter(parameter, index, containerClass);
            return this.resolveParameter(methodParameter);
        }
        return Optional.empty();
    }

    Optional<ResolveParameterHook.ParameterSupplier> resolveParameter(MethodParameter methodParameter) {
        return this.resolvedSuppliers.computeIfAbsent(methodParameter.getRawParameter(), ignore -> this.computeSupplier(methodParameter));
    }

    private Optional<ResolveParameterHook.ParameterSupplier> computeSupplier(MethodParameter methodParameter) {
        DefaultParameterInjectionContext parameterContext = new DefaultParameterInjectionContext(methodParameter);
        return this.resolveParameterHook.resolve((ParameterResolutionContext)parameterContext, this.lifecycleContext);
    }
}

