/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.Optional;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.Reporter;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.execution.AbstractLifecycleContext;
import net.jqwik.engine.execution.ParameterSupplierResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class DefaultContainerLifecycleContext
extends AbstractLifecycleContext
implements ContainerLifecycleContext {
    private final ContainerClassDescriptor classDescriptor;
    private final ParameterSupplierResolver parameterSupplierResolver;

    public DefaultContainerLifecycleContext(ContainerClassDescriptor classDescriptor, Reporter reporter, ResolveParameterHook resolveParameterHook) {
        super(reporter);
        this.classDescriptor = classDescriptor;
        this.parameterSupplierResolver = new ParameterSupplierResolver(resolveParameterHook, this);
    }

    public String label() {
        return this.classDescriptor.getDisplayName();
    }

    public Optional<AnnotatedElement> optionalElement() {
        return Optional.of(this.classDescriptor.getContainerClass());
    }

    public Optional<Class<?>> optionalContainerClass() {
        return Optional.of(this.classDescriptor.getContainerClass());
    }

    public <T> T newInstance(Class<T> clazz) {
        return JqwikReflectionSupport.newInstanceWithDefaultConstructor(clazz);
    }

    public Optional<ResolveParameterHook.ParameterSupplier> resolveParameter(Executable executable, int index) {
        return this.optionalContainerClass().flatMap(containerClass -> this.parameterSupplierResolver.resolveParameter(executable, index, (Class<?>)containerClass));
    }
}

