/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.lifecycle.AfterContainerHook;
import net.jqwik.api.lifecycle.BeforeContainerHook;
import net.jqwik.api.lifecycle.ContainerLifecycleContext;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.Reporter;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.SkipExecutionHook;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.execution.DefaultContainerLifecycleContext;
import net.jqwik.engine.execution.EngineLifecycleContext;
import net.jqwik.engine.execution.ExecutionTaskCreator;
import net.jqwik.engine.execution.PropertyExecutionListener;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.LifecycleHooksSupplier;
import net.jqwik.engine.execution.lifecycle.PlainExecutionResult;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import net.jqwik.engine.execution.pipeline.ExecutionTask;
import net.jqwik.engine.execution.pipeline.Pipeline;
import net.jqwik.engine.execution.pipeline.TaskExecutionResult;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.reporting.ReportEntry;

class ContainerTaskCreator {
    ContainerTaskCreator() {
    }

    ExecutionTask createTask(TestDescriptor containerDescriptor, ExecutionTaskCreator childTaskCreator, Pipeline pipeline, LifecycleHooksSupplier lifecycleSupplier, PropertyExecutionListener propertyExecutionListener) {
        ExecutionTask[] childrenTasks;
        Reporter reporter = (key, value) -> propertyExecutionListener.reportingEntryPublished(containerDescriptor, ReportEntry.from((String)key, (String)value));
        ContainerLifecycleContext containerLifecycleContext = this.createLifecycleContext(containerDescriptor, reporter, lifecycleSupplier);
        SkipExecutionHook.SkipResult skipResult = CurrentTestDescriptor.runWithDescriptor(containerDescriptor, () -> {
            SkipExecutionHook skipExecutionHook = lifecycleSupplier.skipExecutionHook(containerDescriptor);
            return skipExecutionHook.shouldBeSkipped((LifecycleContext)containerLifecycleContext);
        });
        if (skipResult.isSkipped()) {
            return ExecutionTask.from((listener, ignorePredecessorResult) -> {
                listener.executionSkipped(containerDescriptor, skipResult.reason().orElse(null));
                return TaskExecutionResult.success();
            }, containerDescriptor, "skip " + containerDescriptor.getDisplayName());
        }
        BeforeContainerHook beforeContainerHook = lifecycleSupplier.beforeContainerHook(containerDescriptor);
        ExecutionTask prepareContainerTask = ExecutionTask.from((listener, predecessorResult) -> {
            listener.executionStarted(containerDescriptor);
            try {
                beforeContainerHook.beforeContainer(containerLifecycleContext);
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.throwAsUncheckedException(throwable);
            }
            return TaskExecutionResult.success();
        }, containerDescriptor, "prepare " + containerDescriptor.getDisplayName());
        for (ExecutionTask childTask : childrenTasks = this.createChildren(containerDescriptor.getChildren(), childTaskCreator, pipeline, propertyExecutionListener)) {
            pipeline.submit(childTask, prepareContainerTask);
        }
        AfterContainerHook afterContainerHook = lifecycleSupplier.afterContainerHook(containerDescriptor);
        ExecutionTask finishContainerTask = ExecutionTask.from((listener, predecessorResult) -> {
            ExtendedPropertyExecutionResult propertyExecutionResult = predecessorResult.successful() ? PlainExecutionResult.successful() : PlainExecutionResult.failed(predecessorResult.throwable().orElse(null), null);
            try {
                afterContainerHook.afterContainer(containerLifecycleContext);
                TaskExecutionResult taskExecutionResult = predecessorResult;
                return taskExecutionResult;
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                propertyExecutionResult = propertyExecutionResult.mapToFailed(throwable);
                TaskExecutionResult taskExecutionResult = TaskExecutionResult.failure(throwable);
                return taskExecutionResult;
            }
            finally {
                listener.executionFinished(containerDescriptor, propertyExecutionResult);
                StoreRepository.getCurrent().finishScope(containerDescriptor);
            }
        }, containerDescriptor, "finish " + containerDescriptor.getDisplayName());
        if (childrenTasks.length == 0) {
            pipeline.submit(finishContainerTask, prepareContainerTask);
        } else {
            pipeline.submit(finishContainerTask, childrenTasks);
        }
        return prepareContainerTask;
    }

    private ContainerLifecycleContext createLifecycleContext(TestDescriptor containerDescriptor, Reporter reporter, LifecycleHooksSupplier lifecycleSupplier) {
        ResolveParameterHook resolveParameterHook = lifecycleSupplier.resolveParameterHook(containerDescriptor);
        if (containerDescriptor instanceof ContainerClassDescriptor) {
            ContainerClassDescriptor classDescriptor = (ContainerClassDescriptor)containerDescriptor;
            return new DefaultContainerLifecycleContext(classDescriptor, reporter, resolveParameterHook);
        }
        return new EngineLifecycleContext(containerDescriptor, reporter, resolveParameterHook);
    }

    private ExecutionTask[] createChildren(Set<? extends TestDescriptor> children, ExecutionTaskCreator childTaskCreator, Pipeline pipeline, PropertyExecutionListener propertyExecutionListener) {
        ExecutionTask[] childrenTasks = new ExecutionTask[]{};
        return children.stream().map(child -> childTaskCreator.createTask((TestDescriptor)child, pipeline, propertyExecutionListener)).collect(Collectors.toList()).toArray(childrenTasks);
    }
}

